<?php 

// user private page container - contents when unlogged
function pc_so_pvtpag_content() {
	return array(
		'original_content'		=> __("Original content", 'pc_ml'),
		'original_plus_form'	=> __("Original content + login form", 'pc_ml'),
		'form_plus_original'	=> __("Login form + original content", 'pc_ml'),	
		'only_form'				=> __("Only login form", 'pc_ml'),		
	);	
}



// WP user sync - emulable roles
function pc_wps_emulable_roles() {
	global $pc_wp_user;	
	$roles = array();
	
	foreach(get_editable_roles() as $role_id => $data) { 
		if(!in_array($role_id, $pc_wp_user->forbidden_roles)) {
			$roles[ $role_id ] = $data['name'];
		}
	}
				  
	return $roles;
}



// WP capabilities
function pc_wp_roles($role = false) {
	$roles = array(
		'read' 				=> __('Subscriber', 'pc_ml'),
		'edit_posts'		=> __('Contributor', 'pc_ml'),
		'upload_files'		=> __('Author', 'pc_ml'),
		'edit_pages'		=> __('Editor', 'pc_ml'),
		'install_plugins' 	=> __('Administrator', 'pc_ml')
	);
	
	if($role) {return $roles[$role];}
	else {return $roles;}
}



// password strength options
function pc_psw_strength_opts() {
	return array(
		'chars_digits'	=> __('use characters and digits', 'pc_ml'),
		'use_uppercase'	=> __('use uppercase characters', 'pc_ml'),
		'use_symbols'	=> __('use symbols', 'pc_ml')
	);	
}