(function(){

	// creates the plugin
	tinymce.create('tinymce.plugins.PrivateContent', {
		createControl : function(id, controlManager) {
			if (id == 'pc_btn') {
				
				// creates the button
				var pc_sc_button = controlManager.createButton('pc_btn', {
					title : 'PrivateContent Shortcode',
					image : '../wp-content/plugins/private-content/img/users_icon_tinymce.png',  // path to button's image
					onclick : function() {
						
						jQuery.magnificPopup.open({
							items : {
								src: '#pvtcontent_sc_wizard > *',
								type: 'inline'
							},
							mainClass	: 'pc_sc_wizard_lb',
							closeOnContentClick	: false,
							closeOnBgClick		: false, 
							preloader	: false,
							callbacks	: {
							  beforeOpen: function() {
								if(jQuery(window).width() < 800) {
								  this.st.focus = false;
								}
							  },
							  open : function() {
								pc_live_ip_checks();
								pc_live_chosen();
								
								
								// tabify through select
								var lb_class = ".pc_sc_wizard_lb"
								
								jQuery(lb_class+' .lcwp_scw_choser option').each(function() {
									var val = jQuery(this).attr('value');
									
									if(!jQuery(this).is(':selected')) {
										jQuery(lb_class +' '+ val).hide();	
									} else {
										jQuery(lb_class +' '+ val).show();		
									}
								});
								
								// on select change
								jQuery(lb_class).delegate('.lcwp_scw_choser', 'change', function(e) {
									e.preventDefault();
									
									jQuery(lb_class+' .lcwp_scw_choser option').each(function() {
										var val = jQuery(this).attr('value');
									
										if(!jQuery(this).is(':selected')) {
											jQuery(lb_class +' '+ val).hide();	
										} else {
											jQuery(lb_class +' '+ val).show();		
										}
									});
								});
							  }
							}
						});
						jQuery(document).delegate('.mfp-wrap.pc_sc_wizard_lb', 'click', function(e) {
							if(jQuery(e.target).hasClass('mfp-container')) {
								jQuery.magnificPopup.close();
							}
						});
						
					}
				});
				return pc_sc_button;
			}
			return null;
		}
	});
	tinymce.PluginManager.add('PrivateContent', tinymce.plugins.PrivateContent);
	

	////////////////////////////////////////////////////////
	///// pvt-content
	
	// toggle "block" field
	jQuery("body").delegate("#pc_sc_allow", "change", function() {
		var val = (jQuery(this).val() !== null && typeof(jQuery(this).val()) == "object") ? jQuery(this).val() : [];
		var unlogged_chosen = false;

		// if ALL is selected, discard the rest
		if(jQuery.inArray("all", val) !== -1) {
			jQuery(this).find("option").prop("selected", false);
			jQuery(this).find(".pc_all_field").prop("selected", true);
			
			val = ["all"];
			jQuery(this).trigger("chosen:updated");
		}
		
		// if only UNLOGGED is selected, hide block
		else if(jQuery.inArray("unlogged", val) !== -1) {
			if(val.length == 1 && val[0] == "unlogged") { 
				unlogged_chosen = true;
			}
		}
		
		// toggle block field
		if(unlogged_chosen || !val.length) {
			jQuery('.pc_sc_block_wrap').slideUp(200);	
		} else {
			jQuery('.pc_sc_block_wrap').slideDown(200);	
		}
	});
	
	
	// hide message text if no warning is shown
	jQuery('body').delegate('#pg-hide-warning', 'lcs-statuschange', function(){
		if( jQuery(this).is(':checked') ) {
			jQuery('#pg-text_wrap').slideUp();
		} else {
			jQuery('#pg-text_wrap').slideDown();	
		}
	});
	
	
	// handles the click event of the submit button
	jQuery('body').delegate('#pg-pvt-content-submit', 'click', function(){
		var type = jQuery('#pc_sc_type').val();
		var sc = '[pc-pvt-content';
		
		// one value is required
		if(jQuery('#pc_sc_allow').val() === null) {
			alert('Choose who can access contents');	
			return false;
		}
		

		// allowed
		sc += ' allow="' + jQuery('#pc_sc_allow').val().join(',') + '"';
		
		// blocked
		if(jQuery('#pc_sc_block').val() !== null) {
			sc += ' block="' + jQuery('#pc_sc_block').val().join(',') + '"'; 
		}
		
		// show warning box
		if( jQuery('#pg-hide-warning').is(':checked') ) {
			sc += ' warning="0"';	
		} else {
			sc += ' warning="1"';	
		}
		
		// custom message
		if( !jQuery('#pg-hide-warning').is(':checked') && jQuery('#pg-text').val()) {
			sc += ' message="' + jQuery('#pg-text').val() + '"';
		}
		
		// custom login button value
		if( !jQuery('#pg-hide-warning').is(':checked') && jQuery('#pc_sc_login_lb').val()) {
			sc += ' login_lb="' + jQuery('#pc_sc_login_lb').val() + '"';
		}
		
		// custom registration button value
		if( !jQuery('#pg-hide-warning').is(':checked') && jQuery('#pc_sc_registr_lb').val()) {
			sc += ' registr_lb="' + jQuery('#pc_sc_registr_lb').val() + '"';
		}

		// inserts the shortcode into the active editor
		tinyMCE.activeEditor.execCommand('mceInsertContent', 0, sc + '][/pc-pvt-content]');
		
		// closes Thickbox
		jQuery.magnificPopup.close();
	});
	
	
	
	////////////////////////////////////////////////////////
	///// registration-form
	jQuery('body').delegate('#pg-regform-submit', 'click', function(){	
		var sc = '[pc-registration-form';
		
		var form_id = jQuery('#pc_sc_rf_id').val();
		var layout = jQuery('#pc_sc_rf_layout').val();
		var cats = jQuery('#pc_sc_rf_cat').val();
		var redir = jQuery('#pc_sc_rf_redirect').val()
		
		// form id
		if(!form_id) {
			alert("No registration form found");	
			return false;
		}
		else {
			sc += ' id="' + form_id + '"';	
		}
		
		// layout
		if(layout) {
			sc += ' layout="' + layout + '"';		
		}
		
		// cats
		if(cats) {
			sc += ' custom_categories="' + cats.join(',') + '"';			
		}
		
		// redirect
		if(jQuery.trim(redir)) {
			sc += ' redirect="' + redir + '"';			
		}
		
		// alignment
		if(jQuery('#pc_sc_rf_align').val() != 'center') {
			sc += ' align="' + jQuery('#pc_sc_rf_align').val() + '"';		
		}

		// inserts the shortcode into the active editor
		tinyMCE.activeEditor.execCommand('mceInsertContent', 0, sc + ']');
		jQuery.magnificPopup.close();
	});
	
	
	
	////////////////////////////////////////////////////////
	///// login-form
	jQuery('body').delegate('#pg-loginform-submit', 'click', function(){	
		var sc = '[pc-login-form]';
		
		// custom redirect
		if(jQuery('#pc_sc_lf_redirect').val()) {
			sc = sc.replace(']', ' redirect="'+ jQuery('#pc_sc_lf_redirect').val() +'"]');	
		}
		
		// alignment
		if(jQuery('#pc_sc_lf_align').val() != 'center') {
			sc = sc.replace(']', ' align="'+ jQuery('#pc_sc_lf_align').val() +'"]');	
		}
		
		tinyMCE.activeEditor.execCommand('mceInsertContent', 0, sc);
		jQuery.magnificPopup.close();
	});
	
	
	
	////////////////////////////////////////////////////////
	///// logout-box
	jQuery('body').delegate('#pg-logoutbox-submit', 'click', function(){	
		var sc = '[pc-logout-box]';
		
		if(jQuery('#pc_sc_lb_redirect').val()) {
			sc = sc.replace(']', ' redirect="'+ jQuery('#pc_sc_lb_redirect').val() +'"]');	
		}
		
		tinyMCE.activeEditor.execCommand('mceInsertContent', 0, sc);
		jQuery.magnificPopup.close();
	});
	
	
	///////
	
	// init chosen for live elements
	function pc_live_chosen() {
		jQuery('.lcweb-chosen').each(function() {
			var w = jQuery(this).css('width');
			jQuery(this).chosen({width: w}); 
		});
		jQuery(".lcweb-chosen-deselect").chosen({allow_single_deselect:true});
	}
	
	// init iphone checkbox
	function pc_live_ip_checks() {
		jQuery('.ip_checks').lc_switch('YES', 'NO');	
	}
	
})();
