<?php
// GOOGLE ANALYTICS IMPLEMENTATION - USER TRACKING

class pc_google_analytics {
	
	protected 	$ga_url = 'https://www.google-analytics.com/collect';
	protected	$prefix = 'pc-'; // prefix for user ID
	public 		$tid 	= ''; // google tracking ID UA-XXXX-XX
	
	/* setup tracking ID and enables actions */
	public function __construct() {
		$this->tid = get_option('pg_analytics_id');	
		if(empty($this->tid)) {return false;}


		// user pageview	
		if(!is_admin()) {
			add_action('wp_head', array($this, 'set_js_userid'), 1);
			add_action('wp_footer', array($this, 'try_ga_userid'), 9999);
			
			add_action('wp_head', array($this, 'pageview'), 1);
		}	
		
		
		// registration
		add_action('pc_registered_user', array($this, 'registration'), 10, 2);
		
		// login
		add_action('pc_user_login', array($this, 'login'));
		
		// logout
		add_action('pc_user_logout', array($this, 'logout'));
	}

	
	
	// simply add user ID - disabled for now
	public function set_js_userid() {
		if(!isset($GLOBALS['pc_user_id']) || !get_option('pg_analytics_id')) {return false;}
		?>
        <script type="text/javascript">pc_ga_uid = '<?php echo $this->prefix . $GLOBALS['pc_user_id'] ?>';</script>
        <?php
	}
	
	public function try_ga_userid() {
		if(!isset($GLOBALS['pc_user_id']) || !get_option('pg_analytics_id')) {return false;}
		?>
        <script type="text/javascript">
		if(typeof(ga) == 'function') {
			ga('set', 'userId', pc_ga_uid);	
		}
		</script>
        <?php
	}
	
	
	
	////////////////////////////////////////////////////////////////
	
	
	
	/* Logged User pageview */
	public function pageview() {
		if(!isset($GLOBALS['pc_user_id'])) {return false;}

		$params = array(
			't'		=> 'pageview',
			//'ni'	=> 1,
			//'sc'	=> 'start',
		);
		$resp = $this->call($params, $GLOBALS['pc_user_id']);	
	}
	
	
	
	/* registration event */
	public function registration($user_id, $user_status) {
		$params = array(
			't'		=> 'event',
			'ec'	=> 'PrivateContent',
			'ea'	=> 'registration',
			'el'	=> 'User Registration',
			'ni'	=> 0,
		);
		$resp = $this->call($params, $user_id);	

		$this->uid = '';
	}
	
	
	
	/* login event */
	public function login($user_id) {
		$params = array(
			't'		=> 'event',
			'ec'	=> 'PrivateContent',
			'ea'	=> 'login',
			'el'	=> 'User Login',
			'ni'	=> 0,
			'sc'	=> 'start'
		);
		$resp = $this->call($params, $user_id);	
	}
	
	
	
	/* logout event */
	public function logout($user_id) {
		$params = array(
			't'		=> 'event',
			'ec'	=> 'PrivateContent',
			'ea'	=> 'logout',
			'el'	=> 'User Logout',
			'ni'	=> 0,
			'sc'	=> 'end'
		);
		$resp = $this->call($params, $user_id);	
		
		$this->uid = '';
	}
	
	
	
	////////////////////////////////////////////////////////////////
	
	
	/* get user IP */
	private function get_user_IP() {
		$client  = @$_SERVER['HTTP_CLIENT_IP'];
		$forward = @$_SERVER['HTTP_X_FORWARDED_FOR'];
		$remote  = $_SERVER['REMOTE_ADDR'];
		
		if(filter_var($client, FILTER_VALIDATE_IP)) {
			$ip = $client;
		}
		elseif(filter_var($forward, FILTER_VALIDATE_IP)) {
			$ip = $forward;
		}
		else {
			$ip = $remote;
		}
		return $ip;	
	}
	
	
	
	/* POST call to use Google Measurement Protocol */
	public function call($params, $user_id = false) {
		include_once(PC_DIR.'/functions.php');
		
		// get url without base
		$url = str_replace(get_home_url(), '', pc_curr_url());

		$fixed_params = array(
			'v'		=> 1,
			'tid'	=> $this->tid,
			'ds'	=> 'crm',
			'dt'	=> wp_title('', false) . ' | ', 
			'z'		=> rand(1000000, 9999999),
			'uid'	=> $this->prefix . $user_id,
			'dp'	=> $url,
			'an'	=> 'LCweb PrivateContent',
			'av'	=> PC_VERS,
			'uip'	=> $this->get_user_IP(),
			'ua'	=> $_SERVER['HTTP_USER_AGENT'],
			
		);
		$params = array_merge($fixed_params, $params);

		return wp_remote_post('https://www.google-analytics.com/collect', 
			array('body' => $params)
		);
	}
}


// setup - if no integration, delete global
$GLOBALS['pc_google_analytics'] = new pc_google_analytics;
if(empty($GLOBALS['pc_google_analytics']->tid)) {
	unset($GLOBALS['pc_google_analytics']);	
}