<?php
//  visual composer integration


// user categories array builder for VC
function pc_vc_uc_array($bulk_opts = true, $apply_filter = true) {
	include_once(PC_DIR .'/functions.php');
	
	// fix for PCPP
	if(function_exists('pcpp_is_integrated_flag')) {
		pcpp_is_integrated_flag();	
	}
	
	$raw = pc_restr_opts_arr($bulk_opts, $apply_filter);
	
	$arr = array();
	foreach($raw as $block) {
		foreach($block['opts'] as $id => $name) {
			$arr[$name] = $id;	
		}
	}
	return $arr;
}


// revert key => val array into val => key array for Visual Composer
function pc_vc_invert_arr_keys($array) {
	$final = array();
	
	foreach($array as $key => $val) {
		$final[$val] = $key;	
	}
	
	return $final;
}



function pc_on_visual_composer() {
	include_once(PC_DIR .'/functions.php');
    include_once(PC_DIR .'/user_categories.php'); // be sure tax are registered
	
	pc_user_cat_taxonomy();
	$lb_instances = array('' => __('As default', 'pc_ml'), 'none' => __('No login button', 'pc_ml')) + pc_get_lb_instances();
	
	
	#########################################
	######## LOGIN FORM #####################
	#########################################
	
	// parameters
	$params = array(
		array(
			'type' 			=> 'textfield',
			'heading' 		=> __('Custom Redirect', 'pc_ml'),
			'param_name' 	=> 'redirect',
			'admin_label' 	=> true,
			'description'	=> __('Custom redirect (use a valid URL or "<em>refresh</em>" keyword)', 'pc_ml'),
		),
		array(
			'type' 			=> 'dropdown',
			'heading' 		=> __('Alignment', 'pc_ml'),
			'param_name' 	=> 'align',
			'admin_label' 	=> true,
			'value' 		=> array(
				__('Center', 'pc_ml') 	=> 'center',
				__('Left', 'pc_ml') 	=> 'left',
				__('Right', 'pc_ml') 	=> 'right',
			),
		),
	);
	
	// compile
	vc_map(
        array(
            'name' 			=> 'PC - '. __('Login Form', 'pc_ml'),
			'description'	=> __("Displays PrivateContent login form to unlogged users", 'pc_ml'),
            'base' 			=> 'pc-login-form',
            'category' 		=> "PrivateContent",
			'icon'			=> PC_URL .'/img/vc_icon.png',
            'params' 		=> $params,
        )
    );
	
	
	
	
	
	#########################################
	####### LOGOUT BUTTON ###################
	#########################################
	
	// parameters
	$params = array(
		array(
			'type' 			=> 'textfield',
			'heading' 		=> __('Custom Redirect', 'pc_ml'),
			'param_name' 	=> 'redirect',
			'admin_label' 	=> true,
			'description'	=> __("<strong>NOTE:</strong> is possible to directly logout users adding <em>?pc_logout</em> to any site's URL.<br/>Example: <em>http://www.mysite.com/?pc_logout</em>", 'pc_ml')
		),
	);
	
	if(isset($ggom_param)) {
		$params[] = $ggom_param;	
	}
		  
	// compile
	vc_map(
        array(
            'name' 			=> 'PC - '. __('Logout Box', 'pc_ml'),
			'description'	=> __("Displays PrivateContent logout box", 'pc_ml'),
            'base' 			=> 'pc-logout-box',
            'category' 		=> "PrivateContent",
			'icon'			=> PC_URL .'/img/vc_icon.png',
            'params' 		=> $params,
        )
    );
	
	
	
	
	
	#########################################
	######## USER DELETION BOX ##############
	#########################################
	
	// parameters
	$params = array(
		array(
			'type' 			=> 'textfield',
			'heading' 		=> __('Custom Redirect', 'pc_ml'),
			'param_name' 	=> 'redirect',
			'admin_label' 	=> true,
			'description'	=> __('Custom redirect (use a valid URL or "<em>refresh</em>" keyword)', 'pc_ml'),
		),
		array(
			'type' 			=> 'dropdown',
			'heading' 		=> __('Alignment', 'pc_ml'),
			'param_name' 	=> 'align',
			'admin_label' 	=> true,
			'value' 		=> array(
				__('Center', 'pc_ml') 	=> 'center',
				__('Left', 'pc_ml') 	=> 'left',
				__('Right', 'pc_ml') 	=> 'right',
			),
		),
	);
	
	// compile
	vc_map(
        array(
            'name' 			=> 'PC - '. __('User Deletion', 'pc_ml'),
			'description'	=> __("Displays PrivateContent box allowing user's deletion", 'pc_ml'),
            'base' 			=> 'pc-user-del-box',
            'category' 		=> "PrivateContent",
			'icon'			=> PC_URL .'/img/vc_icon.png',
            'params' 		=> $params,
        )
    );
	
	
	


	#########################################
	####### PVTCONTENT SHORTCODE ############
	#########################################
	
	// parameters
	$params = array(
		array(
			'type' 			=> 'checkbox',
			'heading' 		=> __('Who can see contents?', 'pc_ml'),
			'param_name' 	=> 'allow',
			'admin_label' 	=> true,
			'edit_field_class' => 'vc_col-xs-12 vc_column-with-padding pc_vc_multichoice',
			'value' 		=> pc_vc_uc_array()
		),
		array(
			'type' 			=> 'checkbox',
			'heading' 		=> __('Who to block? (optional)', 'pc_ml'),
			'param_name' 	=> 'block',
			'admin_label' 	=> true,
			'edit_field_class' => 'vc_col-xs-12 vc_column-with-padding pc_vc_multichoice',
			'value' 		=> pc_vc_uc_array(false)
		),
		array(
			'type' 			=> 'checkbox',
			'param_name' 	=> 'warning',
			'value' 		=> array(
				'<strong>'. __('Hide warning box?', 'pc_ml') .'</strong>' => 0
			),
			'description'	=> __('By default a yellow warning box is displayed', 'pc_ml'),
		),
		array(
			'type' 			=> 'textfield',
			'heading' 		=> __('Custom message for not allowed users', 'pc_ml'),
			'param_name' 	=> 'message',
			'value' 		=> '',
		),
		array(
			'type' 			=> 'dropdown',
			'heading' 		=> __("Login button's lightbox", 'pc_ml'),
			'param_name' 	=> 'login_lb',
			'admin_label' 	=> true,
			'value' 		=> pc_vc_invert_arr_keys($lb_instances),
		),
		array(
			'type' 			=> 'dropdown',
			'heading' 		=> __("Registration button's lightbox", 'pc_ml'),
			'param_name' 	=> 'registr_lb',
			'admin_label' 	=> true,
			'value' 		=> pc_vc_invert_arr_keys($lb_instances),
		),
		
		
		array(
            "type" => "textarea_html",
            "holder" => "div",
            "heading" => __("Contents", "pc_ml"),
            "param_name" => "content",
            "value" => '',
            "description" => __("Protected content", "pc_ml")
         )
	);
  
	// compile
	vc_map(
        array(
            'name' 			=> 'PC - '. __('Restricted Content', 'pc_ml'),
			'description'	=> __("Hide contents", 'pc_ml'),
            'base' 			=> 'pc-pvt-content',
            'category' 		=> "PrivateContent",
			'icon'			=> PC_URL .'/img/vc_icon.png',
            'params' 		=> $params,
        )
    );
	
	
	

	
	#########################################
	### REGISTRATION FORM SHORTCODE #########
	#########################################

	// forms list
	pc_reg_form_ct();
	$reg_forms = get_terms('pc_reg_form', 'hide_empty=0&order=DESC');	
	
	$reg_form_array = array();
	foreach($reg_forms as $rf) {
		$reg_form_array[ $rf->name ] = $rf->term_id;
	}
		

	// parameters
	$params = array(
		array(
			'type' 			=> 'dropdown',
			'heading' 		=> __('Which form to use?', 'pc_ml'),
			'param_name' 	=> 'id',
			'admin_label' 	=> true,
			'value' 		=> $reg_form_array,
		),
		array(
			'type' 			=> 'dropdown',
			'heading' 		=> __('Layout', 'pc_ml'),
			'param_name' 	=> 'layout',
			'admin_label' 	=> true,
			'value' 		=> array(
				__('Default one', 'pc_ml') => '',
				__('Single column', 'pc_ml') => 'one_col',
				__('Fluid (multi column)', 'pc_ml') => 'fluid',
			),
		),
		array(
			'type' 			=> 'checkbox',
			'heading' 		=> __('Custom categories assignment (ignored if field is in form)', 'pc_ml'),
			'param_name' 	=> 'custom_categories',
			'admin_label' 	=> true,
			'edit_field_class' => 'vc_col-xs-12 vc_column-with-padding pc_vc_multichoice',
			'value' 		=> pc_vc_uc_array(false)
		),
		array(
			'type' 			=> 'textfield',
			'heading' 		=> __('Custom redirect (use a valid URL)', 'mg_ml'),
			'param_name' 	=> 'redirect',
			'admin_label' 	=> true,
			'value' 		=> '',
		),
		array(
			'type' 			=> 'dropdown',
			'heading' 		=> __('Alignment', 'pc_ml'),
			'param_name' 	=> 'align',
			'admin_label' 	=> true,
			'value' 		=> array(
				__('Center', 'pc_ml') 	=> 'center',
				__('Left', 'pc_ml') 	=> 'left',
				__('Right', 'pc_ml') 	=> 'right',
			),
		),
	);
	
  
	// compile
	vc_map(
        array(
            'name' 			=> 'PC - '. __('Registration form', 'pc_ml'),
			'description'	=> __("Displays PrivateContent registration form", 'pc_ml'),
            'base' 			=> 'pc-registration-form',
            'category' 		=> "PrivateContent",
			'icon'			=> PC_URL .'/img/vc_icon.png',
            'params' 		=> $params,
        )
    );
	

}
add_action('vc_before_init', 'pc_on_visual_composer');


