<?php
use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if(!defined('ABSPATH')) exit;



class pc_reg_form_on_elementor extends Widget_Base {
	
	 public function get_icon() {
      return 'emtr_lcweb_icon';
   }
	
	public function get_name() {
		return 'pc-reg-form';
	}

	public function get_categories() {
		return array('privatecontent');
	}

   public function get_title() {
      return 'PC - '. __('Registration Form', 'pc_ml');
   }



	// user categories array builder
	protected function pc_vc_uc_array($bulk_opts = true, $apply_filter = true) {
		include_once(PC_DIR .'/functions.php');
		
		// fix for PCPP
		if(function_exists('pcpp_is_integrated_flag')) {
			pcpp_is_integrated_flag();	
		}
		
		
		include_once(PC_DIR .'/functions.php');	
		$raw = pc_restr_opts_arr($bulk_opts, $apply_filter);
		
		$arr = array();
		foreach($raw as $block) {
			foreach($block['opts'] as $id => $name) {
				$arr[$id] = $name;	
			}
		}
		return $arr;
	}




   protected function _register_controls() {

		// forms list
		pc_reg_form_ct();
		$reg_forms = get_terms('pc_reg_form', 'hide_empty=0&order=DESC');	
		
		$reg_form_array = array();
		foreach($reg_forms as $rf) {
			$reg_form_array[$rf->term_id] = $rf->name;
		}
		


		$this->start_controls_section(
			'main',
			array(
				'label' => 'PrivateContent - '. __('Registration form', 'pc_ml'),
			)
		);
  
  
		$this->add_control(
		   'id',
		   array(
			  'label' 	=> __('Which form to use?', 'pc_ml'),
			  'type' 	=> Controls_Manager::SELECT,
			  'default' => current(array_keys($reg_form_array)),
			  'options' => $reg_form_array
		   )
		);
		
		
		$this->add_control(
		   'layout',
		   array(
			  'label' 	=> __('Layout', 'gg_ml'),
			  'type' 	=> Controls_Manager::SELECT,
			  'default' => '',
			  'options' => array(
			  	'' 			=> __('Default one', 'pc_ml'),
				'one_col'	=> __('Single column', 'pc_ml'),
				'fluid'		=> __('Fluid (multi column)', 'pc_ml'),
			  )
		   )
		);
		

		$this->add_control(
		   'custom_categories',
		   array(
			  'label' 		=> __('Custom categories assignment', 'pc_ml'),
			  'description' => __('Ignored if field is in form', 'pc_ml'),
			  'type' 	=> Controls_Manager::SELECT,
			  'default' => current(array_keys( $this->pc_vc_uc_array(false) )),
			  'options' => $reg_form_array
		   )
		);
		
		
		$this->add_control(
		   'redirect',
		   array(
			  	'label' 		=> __('Custom redirect', 'pc_ml'),
				'description' 	=> __('Use a valid URL', 'pc_ml'),
				'type' 			=> Controls_Manager::TEXT,
		   )
		);
		
		
		$this->add_control(
		   'align',
		   array(
			  'label' 	=> __('Alignment', 'pc_ml'),
			  'type' 	=> Controls_Manager::SELECT,
			  'default' => 'center',
			  'options' => array(
			  	'center' 	=> __('Center', 'pc_ml'),
				'left'		=> __('Left', 'pc_ml'),
				'right'		=> __('Right', 'pc_ml'),
			  )
		   )
		);
		
			
		$this->end_controls_section();
   }


	
	////////////////////////


	protected function render() {
     	$vals = $this->get_settings();
		//var_dump($vals);

		$parts = array('id', 'layout', 'custom_categories', 'redirect', 'align');
		$params = '';
		
		foreach($parts as $part) {
			$params .= $part.'="';
			
			if(!isset($vals[$part])) {$vals[$part] = '';}
			$params .= $vals[$part].'" ';	
		}
		
		echo do_shortcode('[pc-registration-form '. $params .']');
	}


	protected function _content_template() {}
}
