<?php
/**
 * Header Builder: Main loader file
 *
 * @since 0.1.0
 */

// Load the constants, etc.
require_once dirname( __FILE__ ) . '/hb-config.php';
require_once HB_INCLUDES_DIR . '/helpers/array.php';
require_once HB_INCLUDES_DIR . '/class-hb-grid.php';

if ( is_admin() ) {
	require_once  HB_ADMIN_DIR . '/class-hb-db.php';
}

add_action( 'admin_menu', '_hb_add_admin_menu' );
function _hb_add_admin_menu() {
	add_submenu_page( THEME_NAME, __( 'Header Builder', 'mk_framework' ), __( 'Header Builder', 'mk_framework' ), 'edit_theme_options', 'header_builder', '_hb_admin_page' );
}

function _hb_admin_page() {
	include_once( HB_DIR . '/admin/screen.php' );
}

add_filter( 'query_vars', '_hb_add_query_vars_filter' );
function _hb_add_query_vars_filter( $vars ) {
	$vars[] = 'header-builder';
	return $vars;
}

add_filter( 'template_include', '_hb_preview_template', 99 );
function _hb_preview_template( $template ) {
	if ( 'preview' === get_query_var( 'header-builder' ) ) {
		return HB_INCLUDES_DIR . '/templates/preview.php';
	}

	return  $template;
}
