<?php
if (!defined('THEME_FRAMEWORK')) exit('No direct script access allowed');

/**
 * Icon library for svg icons, can be found in WP dashboard > Jupiter > Icon Library
 *
 * @author      Bob Ulusoy
 * @copyright   Artbees LTD (c)
 * @link        http://artbees.net
 * @since       Version 5.1.4
 * @package     artbees
 */

class Mk_Icon_Library {

	var $families;
	var $family;

	function __construct() {

		$this->family = isset($_GET['family']) ? $_GET['family'] : 'line';
		$this->families = array('all','line','icomoon1', 'icomoon2','fontawesome');


		$this->get_library_view();

	}




	/**
	 * construct the page HTML markup
	 * @return HTML
	 *
	 */
	function get_library_view() {

		echo '<div class="wrap icon-library-page">';
		
			echo '<h2>' . __('Theme Icon Library', 'mk_framework') . '</h2>';

			echo '<p>' . __('Search and find your desired icon and paste its <strong>class name</strong> to the <strong>text field</strong> provided in shortcode options.', 'mk_framework') . '</p>';

			echo '<input autocomplete="off" size="60" placeholder="Type a keyword to find your icon... " type="text" class="icon-filter" value="" name="icon-filter-by-name" />';

			echo '<div class="font-family-selector">
				<span>'.__('Select Icon Family', 'mk_framework').'</span>
				';

				foreach ($this->families as $family) {
					echo '<a href="'.admin_url('admin.php?page=icon-library').'&family='.$family.'" class="family-btn '.($this->family == $family ? 'current' : '').'">'.$family.'</a>';
				}
				echo '</div>';

			echo '<div class="mk-font-icons-wrapper">';
				echo '<ul id="icon-lists">';
					echo $this->get_icons_list_view();
				echo '</ul>';
			echo '</div>';

		echo '</div>';

	}

	



	/**
	 * Return the list of icons as HTML markup
	 * @return HTML
	 *
	 */
	function get_icons_list_view() {

		$output = '';

		/*$transient_name = 'mk_svg_icon_library';

		$cached_view = get_transient($transient_name);

		if($cached_view == false) {*/

			$icons_list = $this->get_icons_list($this->family);

			foreach ($icons_list as $class => $unicode) {
				
				$output .= '<li>';
					$output .= '<ul class="icon-box">';
					$output .= '<li class="medium">'.Mk_SVG_Icons::get_svg_icon_by_class_name(false, $class).'</li>';
					$output .= '<li class="class-name"><span>Class Name:</span>' . $class . '</li>';
					$output .= '<li class="character-code"><span>Character Code:</span>' . $unicode . '</li>';
					$output .= '</ul>';
				$output .= '</li>';

			}

			//set_transient($transient_name, $output, MONTH_IN_SECONDS);

			return $output;
		/*}

		return $cached_view;*/

	}



	/**
	 * Returns an array of all icons library (class => unicode) 
	 * @return array
	 *
	 */
	function get_icons_list($family) {


		$line = array(
			"mk-li-web" => "e600",
			"mk-li-volume" => "e601",
			"mk-li-vinyl-disk" => "e602",
			"mk-li-view" => "e603",
			"mk-li-video" => "e604",
			"mk-li-users" => "e605",
			"mk-li-user" => "e606",
			"mk-li-unlock" => "e607",
			"mk-li-umbrella" => "e608",
			"mk-li-tshirt" => "e609",
			"mk-li-truck" => "e60a",
			"mk-li-tool" => "e60b",
			"mk-li-toilet-paper" => "e60c",
			"mk-li-ticket" => "e60d",
			"mk-li-target" => "e60e",
			"mk-li-tablet" => "e60f",
			"mk-li-sun" => "e610",
			"mk-li-star" => "e611",
			"mk-li-smile" => "e612",
			"mk-li-shop" => "e613",
			"mk-li-shield" => "e614",
			"mk-li-settings" => "e615",
			"mk-li-scissor" => "e616",
			"mk-li-safe" => "e617",
			"mk-li-rocket" => "e618",
			"mk-li-refresh" => "e619",
			"mk-li-posion" => "e61a",
			"mk-li-portfolio" => "e61b",
			"mk-li-pinmap" => "e61c",
			"mk-li-pill" => "e61d",
			"mk-li-photo" => "e61e",
			"mk-li-phone" => "e61f",
			"mk-li-pencil" => "e620",
			"mk-li-paper-plane" => "e621",
			"mk-li-notepad" => "e622",
			"mk-li-notebook" => "e623",
			"mk-li-news" => "e624",
			"mk-li-net" => "e625",
			"mk-li-music" => "e626",
			"mk-li-mortarboard" => "e627",
			"mk-li-monitor" => "e628",
			"mk-li-money" => "e629",
			"mk-li-micro" => "e62a",
			"mk-li-message" => "e62b",
			"mk-li-map" => "e62c",
			"mk-li-mail" => "e62d",
			"mk-li-magnet" => "e62e",
			"mk-li-love" => "e62f",
			"mk-li-loupe" => "e630",
			"mk-li-lock" => "e631",
			"mk-li-link" => "e632",
			"mk-li-like" => "e633",
			"mk-li-light" => "e634",
			"mk-li-leaf" => "e635",
			"mk-li-lamp" => "e636",
			"mk-li-lab" => "e637",
			"mk-li-key" => "e638",
			"mk-li-joy" => "e639",
			"mk-li-inbox" => "e63a",
			"mk-li-ice" => "e63b",
			"mk-li-host" => "e63c",
			"mk-li-help" => "e63d",
			"mk-li-headphones" => "e63e",
			"mk-li-graph" => "e63f",
			"mk-li-garbage" => "e640",
			"mk-li-game-pad" => "e641",
			"mk-li-food" => "e642",
			"mk-li-flag" => "e643",
			"mk-li-file" => "e644",
			"mk-li-expand" => "e645",
			"mk-li-drop" => "e646",
			"mk-li-cup" => "e647",
			"mk-li-copy" => "e648",
			"mk-li-config" => "e649",
			"mk-li-compass" => "e64a",
			"mk-li-comments" => "e64b",
			"mk-li-coffee" => "e64c",
			"mk-li-cloud" => "e64d",
			"mk-li-clock" => "e64e",
			"mk-li-clip" => "e64f",
			"mk-li-cinema" => "e650",
			"mk-li-check" => "e651",
			"mk-li-cd" => "e652",
			"mk-li-cassette" => "e653",
			"mk-li-cart" => "e654",
			"mk-li-camera" => "e655",
			"mk-li-call" => "e656",
			"mk-li-calendar" => "e657",
			"mk-li-calculator" => "e658",
			"mk-li-brush" => "e659",
			"mk-li-browser" => "e65a",
			"mk-li-book" => "e65b",
			"mk-li-bicycle" => "e65c",
			"mk-li-bell" => "e65d",
			"mk-li-battery" => "e65e",
			"mk-li-bag" => "e65f",
			"mk-li-attention" => "e660",
			"mk-li-atom" => "e661",
			"mk-li-apeaker" => "e662",
			"mk-li-alarm" => "e663",
			);

		$fontawesome = array(
			"mk-icon-glass" => "f000",
			"mk-icon-music" => "f001",
			"mk-icon-search" => "f002",
			"mk-icon-envelope-o" => "f003",
			"mk-icon-heart" => "f004",
			"mk-icon-star" => "f005",
			"mk-icon-star-o" => "f006",
			"mk-icon-user" => "f007",
			"mk-icon-film" => "f008",
			"mk-icon-th-large" => "f009",
			"mk-icon-th" => "f00a",
			"mk-icon-th-list" => "f00b",
			"mk-icon-check" => "f00c",
			"mk-icon-remove" => "f00d",
			"mk-icon-close" => "f00d",
			"mk-icon-times" => "f00d",
			"mk-icon-search-plus" => "f00e",
			"mk-icon-search-minus" => "f010",
			"mk-icon-power-off" => "f011",
			"mk-icon-signal" => "f012",
			"mk-icon-gear" => "f013",
			"mk-icon-cog" => "f013",
			"mk-icon-trash-o" => "f014",
			"mk-icon-home" => "f015",
			"mk-icon-file-o" => "f016",
			"mk-icon-clock-o" => "f017",
			"mk-icon-road" => "f018",
			"mk-icon-download" => "f019",
			"mk-icon-arrow-circle-o-down" => "f01a",
			"mk-icon-arrow-circle-o-up" => "f01b",
			"mk-icon-inbox" => "f01c",
			"mk-icon-play-circle-o" => "f01d",
			"mk-icon-rotate-right" => "f01e",
			"mk-icon-repeat" => "f01e",
			"mk-icon-refresh" => "f021",
			"mk-icon-list-alt" => "f022",
			"mk-icon-lock" => "f023",
			"mk-icon-flag" => "f024",
			"mk-icon-headphones" => "f025",
			"mk-icon-volume-off" => "f026",
			"mk-icon-volume-down" => "f027",
			"mk-icon-volume-up" => "f028",
			"mk-icon-qrcode" => "f029",
			"mk-icon-barcode" => "f02a",
			"mk-icon-tag" => "f02b",
			"mk-icon-tags" => "f02c",
			"mk-icon-book" => "f02d",
			"mk-icon-bookmark" => "f02e",
			"mk-icon-print" => "f02f",
			"mk-icon-camera" => "f030",
			"mk-icon-font" => "f031",
			"mk-icon-bold" => "f032",
			"mk-icon-italic" => "f033",
			"mk-icon-text-height" => "f034",
			"mk-icon-text-width" => "f035",
			"mk-icon-align-left" => "f036",
			"mk-icon-align-center" => "f037",
			"mk-icon-align-right" => "f038",
			"mk-icon-align-justify" => "f039",
			"mk-icon-list" => "f03a",
			"mk-icon-dedent" => "f03b",
			"mk-icon-outdent" => "f03b",
			"mk-icon-indent" => "f03c",
			"mk-icon-video-camera" => "f03d",
			"mk-icon-photo" => "f03e",
			"mk-icon-image" => "f03e",
			"mk-icon-picture-o" => "f03e",
			"mk-icon-pencil" => "f040",
			"mk-icon-map-marker" => "f041",
			"mk-icon-adjust" => "f042",
			"mk-icon-tint" => "f043",
			"mk-icon-edit" => "f044",
			"mk-icon-pencil-square-o" => "f044",
			"mk-icon-share-square-o" => "f045",
			"mk-icon-check-square-o" => "f046",
			"mk-icon-arrows" => "f047",
			"mk-icon-step-backward" => "f048",
			"mk-icon-fast-backward" => "f049",
			"mk-icon-backward" => "f04a",
			"mk-icon-play" => "f04b",
			"mk-icon-pause" => "f04c",
			"mk-icon-stop" => "f04d",
			"mk-icon-forward" => "f04e",
			"mk-icon-fast-forward" => "f050",
			"mk-icon-step-forward" => "f051",
			"mk-icon-eject" => "f052",
			"mk-icon-chevron-left" => "f053",
			"mk-icon-chevron-right" => "f054",
			"mk-icon-plus-circle" => "f055",
			"mk-icon-minus-circle" => "f056",
			"mk-icon-times-circle" => "f057",
			"mk-icon-check-circle" => "f058",
			"mk-icon-question-circle" => "f059",
			"mk-icon-info-circle" => "f05a",
			"mk-icon-crosshairs" => "f05b",
			"mk-icon-times-circle-o" => "f05c",
			"mk-icon-check-circle-o" => "f05d",
			"mk-icon-ban" => "f05e",
			"mk-icon-arrow-left" => "f060",
			"mk-icon-arrow-right" => "f061",
			"mk-icon-arrow-up" => "f062",
			"mk-icon-arrow-down" => "f063",
			"mk-icon-mail-forward" => "f064",
			"mk-icon-share" => "f064",
			"mk-icon-expand" => "f065",
			"mk-icon-compress" => "f066",
			"mk-icon-plus" => "f067",
			"mk-icon-minus" => "f068",
			"mk-icon-asterisk" => "f069",
			"mk-icon-exclamation-circle" => "f06a",
			"mk-icon-gift" => "f06b",
			"mk-icon-leaf" => "f06c",
			"mk-icon-fire" => "f06d",
			"mk-icon-eye" => "f06e",
			"mk-icon-eye-slash" => "f070",
			"mk-icon-warning" => "f071",
			"mk-icon-exclamation-triangle" => "f071",
			"mk-icon-plane" => "f072",
			"mk-icon-calendar" => "f073",
			"mk-icon-random" => "f074",
			"mk-icon-comment" => "f075",
			"mk-icon-magnet" => "f076",
			"mk-icon-chevron-up" => "f077",
			"mk-icon-chevron-down" => "f078",
			"mk-icon-retweet" => "f079",
			"mk-icon-shopping-cart" => "f07a",
			"mk-icon-folder" => "f07b",
			"mk-icon-folder-open" => "f07c",
			"mk-icon-arrows-v" => "f07d",
			"mk-icon-arrows-h" => "f07e",
			"mk-icon-bar-chart-o" => "f080",
			"mk-icon-bar-chart" => "f080",
			"mk-icon-twitter-square" => "f081",
			"mk-icon-facebook-square" => "f082",
			"mk-icon-camera-retro" => "f083",
			"mk-icon-key" => "f084",
			"mk-icon-gears" => "f085",
			"mk-icon-cogs" => "f085",
			"mk-icon-comments" => "f086",
			"mk-icon-thumbs-o-up" => "f087",
			"mk-icon-thumbs-o-down" => "f088",
			"mk-icon-star-half" => "f089",
			"mk-icon-heart-o" => "f08a",
			"mk-icon-sign-out" => "f08b",
			"mk-icon-linkedin-square" => "f08c",
			"mk-icon-thumb-tack" => "f08d",
			"mk-icon-external-link" => "f08e",
			"mk-icon-sign-in" => "f090",
			"mk-icon-trophy" => "f091",
			"mk-icon-github-square" => "f092",
			"mk-icon-upload" => "f093",
			"mk-icon-lemon-o" => "f094",
			"mk-icon-phone" => "f095",
			"mk-icon-square-o" => "f096",
			"mk-icon-bookmark-o" => "f097",
			"mk-icon-phone-square" => "f098",
			"mk-icon-twitter" => "f099",
			"mk-icon-facebook" => "f09a",
			"mk-icon-github" => "f09b",
			"mk-icon-unlock" => "f09c",
			"mk-icon-credit-card" => "f09d",
			"mk-icon-rss" => "f09e",
			"mk-icon-hdd-o" => "f0a0",
			"mk-icon-bullhorn" => "f0a1",
			"mk-icon-bell" => "f0f3",
			"mk-icon-certificate" => "f0a3",
			"mk-icon-hand-o-right" => "f0a4",
			"mk-icon-hand-o-left" => "f0a5",
			"mk-icon-hand-o-up" => "f0a6",
			"mk-icon-hand-o-down" => "f0a7",
			"mk-icon-arrow-circle-left" => "f0a8",
			"mk-icon-arrow-circle-right" => "f0a9",
			"mk-icon-arrow-circle-up" => "f0aa",
			"mk-icon-arrow-circle-down" => "f0ab",
			"mk-icon-globe" => "f0ac",
			"mk-icon-wrench" => "f0ad",
			"mk-icon-tasks" => "f0ae",
			"mk-icon-filter" => "f0b0",
			"mk-icon-briefcase" => "f0b1",
			"mk-icon-arrows-alt" => "f0b2",
			"mk-icon-group" => "f0c0",
			"mk-icon-users" => "f0c0",
			"mk-icon-chain" => "f0c1",
			"mk-icon-link" => "f0c1",
			"mk-icon-cloud" => "f0c2",
			"mk-icon-flask" => "f0c3",
			"mk-icon-cut" => "f0c4",
			"mk-icon-scissors" => "f0c4",
			"mk-icon-copy" => "f0c5",
			"mk-icon-files-o" => "f0c5",
			"mk-icon-paperclip" => "f0c6",
			"mk-icon-save" => "f0c7",
			"mk-icon-floppy-o" => "f0c7",
			"mk-icon-square" => "f0c8",
			"mk-icon-navicon" => "f0c9",
			"mk-icon-reorder" => "f0c9",
			"mk-icon-bars" => "f0c9",
			"mk-icon-list-ul" => "f0ca",
			"mk-icon-list-ol" => "f0cb",
			"mk-icon-strikethrough" => "f0cc",
			"mk-icon-underline" => "f0cd",
			"mk-icon-table" => "f0ce",
			"mk-icon-magic" => "f0d0",
			"mk-icon-truck" => "f0d1",
			"mk-icon-pinterest" => "f0d2",
			"mk-icon-pinterest-square" => "f0d3",
			"mk-icon-google-plus-square" => "f0d4",
			"mk-icon-google-plus" => "f0d5",
			"mk-icon-money" => "f0d6",
			"mk-icon-caret-down" => "f0d7",
			"mk-icon-caret-up" => "f0d8",
			"mk-icon-caret-left" => "f0d9",
			"mk-icon-caret-right" => "f0da",
			"mk-icon-columns" => "f0db",
			"mk-icon-unsorted" => "f0dc",
			"mk-icon-sort" => "f0dc",
			"mk-icon-sort-down" => "f0dd",
			"mk-icon-sort-desc" => "f0dd",
			"mk-icon-sort-up" => "f0de",
			"mk-icon-sort-asc" => "f0de",
			"mk-icon-envelope" => "f0e0",
			"mk-icon-linkedin" => "f0e1",
			"mk-icon-rotate-left" => "f0e2",
			"mk-icon-undo" => "f0e2",
			"mk-icon-legal" => "f0e3",
			"mk-icon-gavel" => "f0e3",
			"mk-icon-dashboard" => "f0e4",
			"mk-icon-tachometer" => "f0e4",
			"mk-icon-comment-o" => "f0e5",
			"mk-icon-comments-o" => "f0e6",
			"mk-icon-flash" => "f0e7",
			"mk-icon-bolt" => "f0e7",
			"mk-icon-sitemap" => "f0e8",
			"mk-icon-umbrella" => "f0e9",
			"mk-icon-paste" => "f0ea",
			"mk-icon-clipboard" => "f0ea",
			"mk-icon-lightbulb-o" => "f0eb",
			"mk-icon-exchange" => "f0ec",
			"mk-icon-cloud-download" => "f0ed",
			"mk-icon-cloud-upload" => "f0ee",
			"mk-icon-user-md" => "f0f0",
			"mk-icon-stethoscope" => "f0f1",
			"mk-icon-suitcase" => "f0f2",
			"mk-icon-bell-o" => "f0a2",
			"mk-icon-coffee" => "f0f4",
			"mk-icon-cutlery" => "f0f5",
			"mk-icon-file-text-o" => "f0f6",
			"mk-icon-building-o" => "f0f7",
			"mk-icon-hospital-o" => "f0f8",
			"mk-icon-ambulance" => "f0f9",
			"mk-icon-medkit" => "f0fa",
			"mk-icon-fighter-jet" => "f0fb",
			"mk-icon-beer" => "f0fc",
			"mk-icon-h-square" => "f0fd",
			"mk-icon-plus-square" => "f0fe",
			"mk-icon-angle-double-left" => "f100",
			"mk-icon-angle-double-right" => "f101",
			"mk-icon-angle-double-up" => "f102",
			"mk-icon-angle-double-down" => "f103",
			"mk-icon-angle-left" => "f104",
			"mk-icon-angle-right" => "f105",
			"mk-icon-angle-up" => "f106",
			"mk-icon-angle-down" => "f107",
			"mk-icon-desktop" => "f108",
			"mk-icon-laptop" => "f109",
			"mk-icon-tablet" => "f10a",
			"mk-icon-mobile-phone" => "f10b",
			"mk-icon-mobile" => "f10b",
			"mk-icon-circle-o" => "f10c",
			"mk-icon-quote-left" => "f10d",
			"mk-icon-quote-right" => "f10e",
			"mk-icon-spinner" => "f110",
			"mk-icon-circle" => "f111",
			"mk-icon-mail-reply" => "f112",
			"mk-icon-reply" => "f112",
			"mk-icon-github-alt" => "f113",
			"mk-icon-folder-o" => "f114",
			"mk-icon-folder-open-o" => "f115",
			"mk-icon-smile-o" => "f118",
			"mk-icon-frown-o" => "f119",
			"mk-icon-meh-o" => "f11a",
			"mk-icon-gamepad" => "f11b",
			"mk-icon-keyboard-o" => "f11c",
			"mk-icon-flag-o" => "f11d",
			"mk-icon-flag-checkered" => "f11e",
			"mk-icon-terminal" => "f120",
			"mk-icon-code" => "f121",
			"mk-icon-mail-reply-all" => "f122",
			"mk-icon-reply-all" => "f122",
			"mk-icon-star-half-empty" => "f123",
			"mk-icon-star-half-full" => "f123",
			"mk-icon-star-half-o" => "f123",
			"mk-icon-location-arrow" => "f124",
			"mk-icon-crop" => "f125",
			"mk-icon-code-fork" => "f126",
			"mk-icon-unlink" => "f127",
			"mk-icon-chain-broken" => "f127",
			"mk-icon-question" => "f128",
			"mk-icon-info" => "f129",
			"mk-icon-exclamation" => "f12a",
			"mk-icon-superscript" => "f12b",
			"mk-icon-subscript" => "f12c",
			"mk-icon-eraser" => "f12d",
			"mk-icon-puzzle-piece" => "f12e",
			"mk-icon-microphone" => "f130",
			"mk-icon-microphone-slash" => "f131",
			"mk-icon-shield" => "f132",
			"mk-icon-calendar-o" => "f133",
			"mk-icon-fire-extinguisher" => "f134",
			"mk-icon-rocket" => "f135",
			"mk-icon-maxcdn" => "f136",
			"mk-icon-chevron-circle-left" => "f137",
			"mk-icon-chevron-circle-right" => "f138",
			"mk-icon-chevron-circle-up" => "f139",
			"mk-icon-chevron-circle-down" => "f13a",
			"mk-icon-html5" => "f13b",
			"mk-icon-css3" => "f13c",
			"mk-icon-anchor" => "f13d",
			"mk-icon-unlock-alt" => "f13e",
			"mk-icon-bullseye" => "f140",
			"mk-icon-ellipsis-h" => "f141",
			"mk-icon-ellipsis-v" => "f142",
			"mk-icon-rss-square" => "f143",
			"mk-icon-play-circle" => "f144",
			"mk-icon-ticket" => "f145",
			"mk-icon-minus-square" => "f146",
			"mk-icon-minus-square-o" => "f147",
			"mk-icon-level-up" => "f148",
			"mk-icon-level-down" => "f149",
			"mk-icon-check-square" => "f14a",
			"mk-icon-pencil-square" => "f14b",
			"mk-icon-external-link-square" => "f14c",
			"mk-icon-share-square" => "f14d",
			"mk-icon-compass" => "f14e",
			"mk-icon-toggle-down" => "f150",
			"mk-icon-caret-square-o-down" => "f150",
			"mk-icon-toggle-up" => "f151",
			"mk-icon-caret-square-o-up" => "f151",
			"mk-icon-toggle-right" => "f152",
			"mk-icon-caret-square-o-right" => "f152",
			"mk-icon-euro" => "f153",
			"mk-icon-eur" => "f153",
			"mk-icon-gbp" => "f154",
			"mk-icon-dollar" => "f155",
			"mk-icon-usd" => "f155",
			"mk-icon-rupee" => "f156",
			"mk-icon-inr" => "f156",
			"mk-icon-cny" => "f157",
			"mk-icon-rmb" => "f157",
			"mk-icon-yen" => "f157",
			"mk-icon-jpy" => "f157",
			"mk-icon-ruble" => "f158",
			"mk-icon-rouble" => "f158",
			"mk-icon-rub" => "f158",
			"mk-icon-won" => "f159",
			"mk-icon-krw" => "f159",
			"mk-icon-bitcoin" => "f15a",
			"mk-icon-btc" => "f15a",
			"mk-icon-file" => "f15b",
			"mk-icon-file-text" => "f15c",
			"mk-icon-sort-alpha-asc" => "f15d",
			"mk-icon-sort-alpha-desc" => "f15e",
			"mk-icon-sort-amount-asc" => "f160",
			"mk-icon-sort-amount-desc" => "f161",
			"mk-icon-sort-numeric-asc" => "f162",
			"mk-icon-sort-numeric-desc" => "f163",
			"mk-icon-thumbs-up" => "f164",
			"mk-icon-thumbs-down" => "f165",
			"mk-icon-youtube-square" => "f166",
			"mk-icon-youtube" => "f167",
			"mk-icon-xing" => "f168",
			"mk-icon-xing-square" => "f169",
			"mk-icon-youtube-play" => "f16a",
			"mk-icon-dropbox" => "f16b",
			"mk-icon-stack-overflow" => "f16c",
			"mk-icon-instagram" => "f16d",
			"mk-icon-flickr" => "f16e",
			"mk-icon-adn" => "f170",
			"mk-icon-bitbucket" => "f171",
			"mk-icon-bitbucket-square" => "f172",
			"mk-icon-tumblr" => "f173",
			"mk-icon-tumblr-square" => "f174",
			"mk-icon-long-arrow-down" => "f175",
			"mk-icon-long-arrow-up" => "f176",
			"mk-icon-long-arrow-left" => "f177",
			"mk-icon-long-arrow-right" => "f178",
			"mk-icon-apple" => "f179",
			"mk-icon-windows" => "f17a",
			"mk-icon-android" => "f17b",
			"mk-icon-linux" => "f17c",
			"mk-icon-dribbble" => "f17d",
			"mk-icon-skype" => "f17e",
			"mk-icon-foursquare" => "f180",
			"mk-icon-trello" => "f181",
			"mk-icon-female" => "f182",
			"mk-icon-male" => "f183",
			"mk-icon-gittip" => "f184",
			"mk-icon-sun-o" => "f185",
			"mk-icon-moon-o" => "f186",
			"mk-icon-archive" => "f187",
			"mk-icon-bug" => "f188",
			"mk-icon-vk" => "f189",
			"mk-icon-weibo" => "f18a",
			"mk-icon-renren" => "f18b",
			"mk-icon-pagelines" => "f18c",
			"mk-icon-stack-exchange" => "f18d",
			"mk-icon-arrow-circle-o-right" => "f18e",
			"mk-icon-arrow-circle-o-left" => "f190",
			"mk-icon-toggle-left" => "f191",
			"mk-icon-caret-square-o-left" => "f191",
			"mk-icon-dot-circle-o" => "f192",
			"mk-icon-wheelchair" => "f193",
			"mk-icon-vimeo-square" => "f194",
			"mk-icon-turkish-lira" => "f195",
			"mk-icon-try" => "f195",
			"mk-icon-plus-square-o" => "f196",
			"mk-icon-space-shuttle" => "f197",
			"mk-icon-slack" => "f198",
			"mk-icon-envelope-square" => "f199",
			"mk-icon-wordpress" => "f19a",
			"mk-icon-openid" => "f19b",
			"mk-icon-institution" => "f19c",
			"mk-icon-bank" => "f19c",
			"mk-icon-university" => "f19c",
			"mk-icon-mortar-board" => "f19d",
			"mk-icon-graduation-cap" => "f19d",
			"mk-icon-yahoo" => "f19e",
			"mk-icon-google" => "f1a0",
			"mk-icon-reddit" => "f1a1",
			"mk-icon-reddit-square" => "f1a2",
			"mk-icon-stumbleupon-circle" => "f1a3",
			"mk-icon-stumbleupon" => "f1a4",
			"mk-icon-delicious" => "f1a5",
			"mk-icon-digg" => "f1a6",
			"mk-icon-pied-piper" => "f1a7",
			"mk-icon-pied-piper-alt" => "f1a8",
			"mk-icon-drupal" => "f1a9",
			"mk-icon-joomla" => "f1aa",
			"mk-icon-language" => "f1ab",
			"mk-icon-fax" => "f1ac",
			"mk-icon-building" => "f1ad",
			"mk-icon-child" => "f1ae",
			"mk-icon-paw" => "f1b0",
			"mk-icon-spoon" => "f1b1",
			"mk-icon-cube" => "f1b2",
			"mk-icon-cubes" => "f1b3",
			"mk-icon-behance" => "f1b4",
			"mk-icon-behance-square" => "f1b5",
			"mk-icon-steam" => "f1b6",
			"mk-icon-steam-square" => "f1b7",
			"mk-icon-recycle" => "f1b8",
			"mk-icon-automobile" => "f1b9",
			"mk-icon-car" => "f1b9",
			"mk-icon-cab" => "f1ba",
			"mk-icon-taxi" => "f1ba",
			"mk-icon-tree" => "f1bb",
			"mk-icon-spotify" => "f1bc",
			"mk-icon-deviantart" => "f1bd",
			"mk-icon-soundcloud" => "f1be",
			"mk-icon-database" => "f1c0",
			"mk-icon-file-pdf-o" => "f1c1",
			"mk-icon-file-word-o" => "f1c2",
			"mk-icon-file-excel-o" => "f1c3",
			"mk-icon-file-powerpoint-o" => "f1c4",
			"mk-icon-file-photo-o" => "f1c5",
			"mk-icon-file-picture-o" => "f1c5",
			"mk-icon-file-image-o" => "f1c5",
			"mk-icon-file-zip-o" => "f1c6",
			"mk-icon-file-archive-o" => "f1c6",
			"mk-icon-file-sound-o" => "f1c7",
			"mk-icon-file-audio-o" => "f1c7",
			"mk-icon-file-movie-o" => "f1c8",
			"mk-icon-file-video-o" => "f1c8",
			"mk-icon-file-code-o" => "f1c9",
			"mk-icon-vine" => "f1ca",
			"mk-icon-codepen" => "f1cb",
			"mk-icon-jsfiddle" => "f1cc",
			"mk-icon-life-bouy" => "f1cd",
			"mk-icon-life-buoy" => "f1cd",
			"mk-icon-life-saver" => "f1cd",
			"mk-icon-support" => "f1cd",
			"mk-icon-life-ring" => "f1cd",
			"mk-icon-circle-o-notch" => "f1ce",
			"mk-icon-ra" => "f1d1",
			"mk-icon-rebel" => "f1d1",
			"mk-icon-ge" => "f1d1",
			"mk-icon-empire" => "f1d1",
			"mk-icon-git-square" => "f1d2",
			"mk-icon-git" => "f1d3",
			"mk-icon-hacker-news" => "f1d4",
			"mk-icon-tencent-weibo" => "f1d5",
			"mk-icon-qq" => "f1d6",
			"mk-icon-wechat" => "f1d7",
			"mk-icon-weixin" => "f1d7",
			"mk-icon-send" => "f1d8",
			"mk-icon-paper-plane" => "f1d8",
			"mk-icon-send-o" => "f1d9",
			"mk-icon-paper-plane-o" => "f1d9",
			"mk-icon-history" => "f1da",
			"mk-icon-circle-thin" => "f1db",
			"mk-icon-header" => "f1dc",
			"mk-icon-paragraph" => "f1dd",
			"mk-icon-sliders" => "f1de",
			"mk-icon-share-alt" => "f1e0",
			"mk-icon-share-alt-square" => "f1e1",
			"mk-icon-bomb" => "f1e2",
			"mk-icon-soccer-ball-o" => "f1e3",
			"mk-icon-futbol-o" => "f1e3",
			"mk-icon-tty" => "f1e4",
			"mk-icon-binoculars" => "f1e5",
			"mk-icon-plug" => "f1e6",
			"mk-icon-slideshare" => "f1e7",
			"mk-icon-twitch" => "f1e8",
			"mk-icon-yelp" => "f1e9",
			"mk-icon-newspaper-o" => "f1ea",
			"mk-icon-wifi" => "f1eb",
			"mk-icon-calculator" => "f1ec",
			"mk-icon-paypal" => "f1ed",
			"mk-icon-google-wallet" => "f1ee",
			"mk-icon-cc-visa" => "f1f0",
			"mk-icon-cc-mastercard" => "f1f1",
			"mk-icon-cc-discover" => "f1f2",
			"mk-icon-cc-amex" => "f1f3",
			"mk-icon-cc-paypal" => "f1f4",
			"mk-icon-cc-stripe" => "f1f5",
			"mk-icon-bell-slash" => "f1f6",
			"mk-icon-bell-slash-o" => "f1f7",
			"mk-icon-trash" => "f1f8",
			"mk-icon-copyright" => "f1f9",
			"mk-icon-at" => "f1fa",
			"mk-icon-eyedropper" => "f1fb",
			"mk-icon-paint-brush" => "f1fc",
			"mk-icon-birthday-cake" => "f1fd",
			"mk-icon-area-chart" => "f1fe",
			"mk-icon-pie-chart" => "f200",
			"mk-icon-line-chart" => "f201",
			"mk-icon-lastfm" => "f202",
			"mk-icon-lastfm-square" => "f203",
			"mk-icon-toggle-off" => "f204",
			"mk-icon-toggle-on" => "f205",
			"mk-icon-bicycle" => "f206",
			"mk-icon-bus" => "f207",
			"mk-icon-ioxhost" => "f208",
			"mk-icon-angellist" => "f209",
			"mk-icon-cc" => "f20a",
			"mk-icon-shekel" => "f20b",
			"mk-icon-sheqel" => "f20b",
			"mk-icon-ils" => "f20b",
			"mk-icon-meanpath" => "f20c",
			);


		$icomoon1 =  array(
			"mk-moon-home" => "21",
			"mk-moon-home-2" => "22",
			"mk-moon-home-3" => "23",
			"mk-moon-home-4" => "24",
			"mk-moon-home-5" => "25",
			"mk-moon-home-6" => "26",
			"mk-moon-quill" => "27",
			"mk-moon-quill-2" => "28",
			"mk-moon-pen" => "29",
			"mk-moon-pen-2" => "2a",
			"mk-moon-pen-3" => "2b",
			"mk-moon-pen-4" => "2c",
			"mk-moon-droplet" => "2d",
			"mk-moon-paint-format" => "2e",
			"mk-moon-paint-format-2" => "2f",
			"mk-moon-image" => "30",
			"mk-moon-image-2" => "31",
			"mk-moon-image-3" => "32",
			"mk-moon-music" => "33",
			"mk-moon-music-2" => "34",
			"mk-moon-piano" => "35",
			"mk-moon-guitar" => "36",
			"mk-moon-headphones" => "37",
			"mk-moon-headphones-2" => "38",
			"mk-moon-dice" => "39",
			"mk-moon-gamepad" => "3a",
			"mk-moon-gamepad-2" => "3b",
			"mk-moon-gamepad-3" => "3c",
			"mk-moon-pacman" => "3d",
			"mk-moon-spades" => "3e",
			"mk-moon-podcast" => "3f",
			"mk-moon-radio" => "40",
			"mk-moon-feed" => "41",
			"mk-moon-connection" => "42",
			"mk-moon-radio-2" => "43",
			"mk-moon-podcast-2" => "44",
			"mk-moon-profile" => "45",
			"mk-moon-file" => "46",
			"mk-moon-file-2" => "47",
			"mk-moon-file-3" => "48",
			"mk-moon-file-4" => "49",
			"mk-moon-file-5" => "4a",
			"mk-moon-file-remove" => "4b",
			"mk-moon-file-6" => "4c",
			"mk-moon-copy" => "4d",
			"mk-moon-copy-2" => "4e",
			"mk-moon-copy-3" => "4f",
			"mk-moon-copy-4" => "50",
			"mk-moon-folder-remove" => "51",
			"mk-moon-folder" => "52",
			"mk-moon-folder-open" => "53",
			"mk-moon-folder-2" => "54",
			"mk-moon-folder-3" => "55",
			"mk-moon-folder-plus" => "56",
			"mk-moon-tag" => "57",
			"mk-moon-tag-2" => "58",
			"mk-moon-tag-3" => "59",
			"mk-moon-tag-4" => "5a",
			"mk-moon-tag-5" => "5b",
			"mk-moon-tag-6" => "5c",
			"mk-moon-cart-plus" => "5d",
			"mk-moon-cart-minus" => "5e",
			"mk-moon-cart-add" => "5f",
			"mk-moon-cart-remove" => "60",
			"mk-moon-cart-checkout" => "61",
			"mk-moon-cart-remove-2" => "62",
			"mk-moon-phone" => "63",
			"mk-moon-phone-2" => "64",
			"mk-moon-contact-add" => "65",
			"mk-moon-contact-remove" => "66",
			"mk-moon-contact-add-2" => "67",
			"mk-moon-contact-remove-2" => "68",
			"mk-moon-pushpin" => "69",
			"mk-moon-location" => "6a",
			"mk-moon-location-2" => "6b",
			"mk-moon-location-3" => "6c",
			"mk-moon-location-4" => "6d",
			"mk-moon-location-5" => "6e",
			"mk-moon-location-6" => "6f",
			"mk-moon-location-7" => "70",
			"mk-moon-compass" => "71",
			"mk-moon-compass-2" => "72",
			"mk-moon-map" => "73",
			"mk-moon-map-2" => "74",
			"mk-moon-map-3" => "75",
			"mk-moon-map-4" => "76",
			"mk-moon-direction" => "77",
			"mk-moon-history" => "78",
			"mk-moon-history-2" => "79",
			"mk-moon-clock" => "7a",
			"mk-moon-clock-2" => "7b",
			"mk-moon-clock-3" => "7c",
			"mk-moon-clock-4" => "7d",
			"mk-moon-watch" => "7e",
			"mk-moon-clock-5" => "e000",
			"mk-moon-clock-6" => "e001",
			"mk-moon-clock-7" => "e002",
			"mk-moon-alarm" => "e003",
			"mk-moon-alarm-2" => "e004",
			"mk-moon-bell" => "e005",
			"mk-moon-bell-2" => "e006",
			"mk-moon-alarm-plus" => "e007",
			"mk-moon-alarm-minus" => "e008",
			"mk-moon-alarm-check" => "e009",
			"mk-moon-alarm-cancel" => "e00a",
			"mk-moon-stopwatch" => "e00b",
			"mk-moon-calendar" => "e00c",
			"mk-moon-calendar-2" => "e00d",
			"mk-moon-calendar-3" => "e00e",
			"mk-moon-calendar-4" => "e00f",
			"mk-moon-calendar-5" => "e010",
			"mk-moon-print" => "e011",
			"mk-moon-print-2" => "e012",
			"mk-moon-print-3" => "e013",
			"mk-moon-mouse" => "e014",
			"mk-moon-mouse-2" => "e015",
			"mk-moon-mouse-3" => "e016",
			"mk-moon-mouse-4" => "e017",
			"mk-moon-keyboard" => "e018",
			"mk-moon-keyboard-2" => "e019",
			"mk-moon-screen" => "e01a",
			"mk-moon-screen-2" => "e01b",
			"mk-moon-screen-3" => "e01c",
			"mk-moon-screen-4" => "e01d",
			"mk-moon-laptop" => "e01e",
			"mk-moon-mobile" => "e01f",
			"mk-moon-mobile-2" => "e020",
			"mk-moon-tablet" => "e021",
			"mk-moon-mobile-3" => "e022",
			"mk-moon-tv" => "e023",
			"mk-moon-cabinet" => "e024",
			"mk-moon-archive" => "e025",
			"mk-moon-drawer" => "e026",
			"mk-moon-drawer-2" => "e027",
			"mk-moon-drawer-3" => "e028",
			"mk-moon-box" => "e029",
			"mk-moon-box-add" => "e02a",
			"mk-moon-box-remove" => "e02b",
			"mk-moon-download" => "e02c",
			"mk-moon-upload" => "e02d",
			"mk-moon-disk" => "e02e",
			"mk-moon-cd" => "e02f",
			"mk-moon-storage" => "e030",
			"mk-moon-storage-2" => "e031",
			"mk-moon-database" => "e032",
			"mk-moon-database-2" => "e033",
			"mk-moon-database-3" => "e034",
			"mk-moon-undo" => "e035",
			"mk-moon-redo" => "e036",
			"mk-moon-rotate" => "e037",
			"mk-moon-rotate-2" => "e038",
			"mk-moon-flip" => "e039",
			"mk-moon-flip-2" => "e03a",
			"mk-moon-unite" => "e03b",
			"mk-moon-subtract" => "e03c",
			"mk-moon-interset" => "e03d",
			"mk-moon-exclude" => "e03e",
			"mk-moon-align-left" => "e03f",
			"mk-moon-align-center-horizontal" => "e040",
			"mk-moon-align-right" => "e041",
			"mk-moon-align-top" => "e042",
			"mk-moon-align-center-vertical" => "e043",
			"mk-moon-align-bottom" => "e044",
			"mk-moon-undo-2" => "e045",
			"mk-moon-redo-2" => "e046",
			"mk-moon-forward" => "e047",
			"mk-moon-reply" => "e048",
			"mk-moon-reply-2" => "e049",
			"mk-moon-bubble" => "e04a",
			"mk-moon-bubbles" => "e04b",
			"mk-moon-bubbles-2" => "e04c",
			"mk-moon-bubble-2" => "e04d",
			"mk-moon-bubbles-3" => "e04e",
			"mk-moon-bubbles-4" => "e04f",
			"mk-moon-bubble-notification" => "e050",
			"mk-moon-bubbles-5" => "e051",
			"mk-moon-bubbles-6" => "e052",
			"mk-moon-bubble-3" => "e053",
			"mk-moon-bubble-dots" => "e054",
			"mk-moon-bubble-4" => "e055",
			"mk-moon-bubble-5" => "e056",
			"mk-moon-bubble-dots-2" => "e057",
			"mk-moon-bubble-6" => "e058",
			"mk-moon-bubble-7" => "e059",
			"mk-moon-bubble-8" => "e05a",
			"mk-moon-bubbles-7" => "e05b",
			"mk-moon-bubble-9" => "e05c",
			"mk-moon-bubbles-8" => "e05d",
			"mk-moon-bubble-10" => "e05e",
			"mk-moon-bubble-dots-3" => "e05f",
			"mk-moon-bubble-11" => "e060",
			"mk-moon-bubble-12" => "e061",
			"mk-moon-bubble-dots-4" => "e062",
			"mk-moon-bubble-13" => "e063",
			"mk-moon-bubbles-9" => "e064",
			"mk-moon-bubbles-10" => "e065",
			"mk-moon-bubble-blocked" => "e066",
			"mk-moon-bubble-quote" => "e067",
			"mk-moon-bubble-user" => "e068",
			"mk-moon-bubble-check" => "e069",
			"mk-moon-bubble-video-chat" => "e06a",
			"mk-moon-bubble-link" => "e06b",
			"mk-moon-bubble-locked" => "e06c",
			"mk-moon-bubble-star" => "e06d",
			"mk-moon-bubble-heart" => "e06e",
			"mk-moon-bubble-paperclip" => "e06f",
			"mk-moon-bubble-cancel" => "e070",
			"mk-moon-bubble-plus" => "e071",
			"mk-moon-bubble-minus" => "e072",
			"mk-moon-bubble-notification-2" => "e073",
			"mk-moon-bubble-trash" => "e074",
			"mk-moon-bubble-left" => "e075",
			"mk-moon-bubble-right" => "e076",
			"mk-moon-bubble-up" => "e077",
			"mk-moon-bubble-down" => "e078",
			"mk-moon-bubble-first" => "e079",
			"mk-moon-bubble-last" => "e07a",
			"mk-moon-bubble-replu" => "e07b",
			"mk-moon-bubble-forward" => "e07c",
			"mk-moon-bubble-reply" => "e07d",
			"mk-moon-bubble-forward-2" => "e07e",
			"mk-moon-user" => "e07f",
			"mk-moon-users" => "e080",
			"mk-moon-user-plus" => "e081",
			"mk-moon-user-plus-2" => "e082",
			"mk-moon-user-minus" => "e083",
			"mk-moon-user-minus-2" => "e084",
			"mk-moon-user-cancel" => "e085",
			"mk-moon-user-block" => "e086",
			"mk-moon-users-2" => "e087",
			"mk-moon-user-2" => "e088",
			"mk-moon-users-3" => "e089",
			"mk-moon-user-plus-3" => "e08a",
			"mk-moon-user-minus-3" => "e08b",
			"mk-moon-user-cancel-2" => "e08c",
			"mk-moon-user-block-2" => "e08d",
			"mk-moon-user-3" => "e08e",
			"mk-moon-user-4" => "e08f",
			"mk-moon-user-5" => "e090",
			"mk-moon-user-6" => "e091",
			"mk-moon-users-4" => "e092",
			"mk-moon-user-7" => "e093",
			"mk-moon-user-8" => "e094",
			"mk-moon-users-5" => "e095",
			"mk-moon-vcard" => "e096",
			"mk-moon-tshirt" => "e097",
			"mk-moon-hanger" => "e098",
			"mk-moon-quotes-left" => "e099",
			"mk-moon-quotes-right" => "e09a",
			"mk-moon-quotes-right-2" => "e09b",
			"mk-moon-quotes-right-3" => "e09c",
			"mk-moon-busy" => "e09d",
			"mk-moon-busy-2" => "e09e",
			"mk-moon-busy-3" => "e09f",
			"mk-moon-busy-4" => "e0a0",
			"mk-moon-spinner" => "e0a1",
			"mk-moon-spinner-2" => "e0a2",
			"mk-moon-spinner-3" => "e0a3",
			"mk-moon-spinner-4" => "e0a4",
			"mk-moon-spinner-5" => "e0a5",
			"mk-moon-spinner-6" => "e0a6",
			"mk-moon-spinner-7" => "e0a7",
			"mk-moon-spinner-8" => "e0a8",
			"mk-moon-spinner-9" => "e0a9",
			"mk-moon-spinner-10" => "e0aa",
			"mk-moon-spinner-11" => "e0ab",
			"mk-moon-spinner-12" => "e0ac",
			"mk-moon-microscope" => "e0ad",
			"mk-moon-binoculars" => "e0ae",
			"mk-moon-binoculars-2" => "e0af",
			"mk-moon-search" => "e0b0",
			"mk-moon-search-2" => "e0b1",
			"mk-moon-zoom-in" => "e0b2",
			"mk-moon-zoom-out" => "e0b3",
			"mk-moon-search-3" => "e0b4",
			"mk-moon-search-4" => "e0b5",
			"mk-moon-zoom-in-2" => "e0b6",
			"mk-moon-zoom-out-2" => "e0b7",
			"mk-moon-search-5" => "e0b8",
			"mk-moon-expand" => "e0b9",
			"mk-moon-contract" => "e0ba",
			"mk-moon-scale-up" => "e0bb",
			"mk-moon-scale-down" => "e0bc",
			"mk-moon-expand-2" => "e0bd",
			"mk-moon-contract-2" => "e0be",
			"mk-moon-scale-up-2" => "e0bf",
			"mk-moon-scale-down-2" => "e0c0",
			"mk-moon-fullscreen" => "e0c1",
			"mk-moon-expand-3" => "e0c2",
			"mk-moon-contract-3" => "e0c3",
			"mk-moon-key" => "e0c4",
			"mk-moon-key-2" => "e0c5",
			"mk-moon-key-3" => "e0c6",
			"mk-moon-key-4" => "e0c7",
			"mk-moon-key-5" => "e0c8",
			"mk-moon-keyhole" => "e0c9",
			"mk-moon-lock" => "e0ca",
			"mk-moon-lock-2" => "e0cb",
			"mk-moon-lock-3" => "e0cc",
			"mk-moon-lock-4" => "e0cd",
			"mk-moon-unlocked" => "e0ce",
			"mk-moon-lock-5" => "e0cf",
			"mk-moon-unlocked-2" => "e0d0",
			"mk-moon-wrench" => "e0d1",
			"mk-moon-wrench-2" => "e0d2",
			"mk-moon-wrench-3" => "e0d3",
			"mk-moon-wrench-4" => "e0d4",
			"mk-moon-settings" => "e0d5",
			"mk-moon-equalizer" => "e0d6",
			"mk-moon-equalizer-2" => "e0d7",
			"mk-moon-equalizer-3" => "e0d8",
			"mk-moon-cog" => "e0d9",
			"mk-moon-cogs" => "e0da",
			"mk-moon-cog-2" => "e0db",
			"mk-moon-cog-3" => "e0dc",
			"mk-moon-cog-4" => "e0dd",
			"mk-moon-cog-5" => "e0de",
			"mk-moon-cog-6" => "e0df",
			"mk-moon-cog-7" => "e0e0",
			"mk-moon-factory" => "e0e1",
			"mk-moon-hammer" => "e0e2",
			"mk-moon-tools" => "e0e3",
			"mk-moon-screwdriver" => "e0e4",
			"mk-moon-screwdriver-2" => "e0e5",
			"mk-moon-wand" => "e0e6",
			"mk-moon-wand-2" => "e0e7",
			"mk-moon-health" => "e0e8",
			"mk-moon-aid" => "e0e9",
			"mk-moon-patch" => "e0ea",
			"mk-moon-bug" => "e0eb",
			"mk-moon-bug-2" => "e0ec",
			"mk-moon-inject" => "e0ed",
			"mk-moon-inject-2" => "e0ee",
			"mk-moon-construction" => "e0ef",
			"mk-moon-cone" => "e0f0",
			"mk-moon-pie" => "e0f1",
			"mk-moon-pie-2" => "e0f2",
			"mk-moon-pie-3" => "e0f3",
			"mk-moon-pie-4" => "e0f4",
			"mk-moon-pie-5" => "e0f5",
			"mk-moon-pie-6" => "e0f6",
			"mk-moon-pie-7" => "e0f7",
			"mk-moon-stats" => "e0f8",
			"mk-moon-stats-2" => "e0f9",
			"mk-moon-stats-3" => "e0fa",
			"mk-moon-bars" => "e0fb",
			"mk-moon-bars-2" => "e0fc",
			"mk-moon-bars-3" => "e0fd",
			"mk-moon-bars-4" => "e0fe",
			"mk-moon-bars-5" => "e0ff",
			"mk-moon-bars-6" => "e100",
			"mk-moon-stats-up" => "e101",
			"mk-moon-stats-down" => "e102",
			"mk-moon-stairs-down" => "e103",
			"mk-moon-stairs-down-2" => "e104",
			"mk-moon-chart" => "e105",
			"mk-moon-stairs" => "e106",
			"mk-moon-stairs-2" => "e107",
			"mk-moon-ladder" => "e108",
			"mk-moon-cake" => "e109",
			"mk-moon-gift" => "e10a",
			"mk-moon-gift-2" => "e10b",
			"mk-moon-balloon" => "e10c",
			"mk-moon-rating" => "e10d",
			"mk-moon-rating-2" => "e10e",
			"mk-moon-rating-3" => "e10f",
			"mk-moon-podium" => "e110",
			"mk-moon-medal" => "e111",
			"mk-moon-medal-2" => "e112",
			"mk-moon-medal-3" => "e113",
			"mk-moon-medal-4" => "e114",
			"mk-moon-medal-5" => "e115",
			"mk-moon-crown" => "e116",
			"mk-moon-trophy" => "e117",
			"mk-moon-trophy-2" => "e118",
			"mk-moon-trophy-star" => "e119",
			"mk-moon-diamond" => "e11a",
			"mk-moon-diamond-2" => "e11b",
			"mk-moon-glass" => "e11c",
			"mk-moon-glass-2" => "e11d",
			"mk-moon-bottle" => "e11e",
			"mk-moon-bottle-2" => "e11f",
			"mk-moon-mug" => "e120",
			"mk-moon-food" => "e121",
			"mk-moon-food-2" => "e122",
			"mk-moon-hamburger" => "e123",
			"mk-moon-cup" => "e124",
			"mk-moon-cup-2" => "e125",
			"mk-moon-leaf" => "e126",
			"mk-moon-leaf-2" => "e127",
			"mk-moon-apple-fruit" => "e128",
			"mk-moon-tree" => "e129",
			"mk-moon-tree-2" => "e12a",
			"mk-moon-paw" => "e12b",
			"mk-moon-steps" => "e12c",
			"mk-moon-flower" => "e12d",
			"mk-moon-rocket" => "e12e",
			"mk-moon-meter" => "e12f",
			"mk-moon-meter2" => "e130",
			"mk-moon-meter-slow" => "e131",
			"mk-moon-meter-medium" => "e132",
			"mk-moon-meter-fast" => "e133",
			"mk-moon-dashboard" => "e134",
			"mk-moon-hammer-2" => "e135",
			"mk-moon-balance" => "e136",
			"mk-moon-bomb" => "e137",
			"mk-moon-fire" => "e138",
			"mk-moon-fire-2" => "e139",
			"mk-moon-lab" => "e13a",
			"mk-moon-atom" => "e13b",
			"mk-moon-atom-2" => "e13c",
			"mk-moon-magnet" => "e13d",
			"mk-moon-magnet-2" => "e13e",
			"mk-moon-magnet-3" => "e13f",
			"mk-moon-magnet-4" => "e140",
			"mk-moon-dumbbell" => "e141",
			"mk-moon-skull" => "e142",
			"mk-moon-skull-2" => "e143",
			"mk-moon-skull-3" => "e144",
			"mk-moon-lamp" => "e145",
			"mk-moon-lamp-2" => "e146",
			"mk-moon-lamp-3" => "e147",
			"mk-moon-lamp-4" => "e148",
			"mk-moon-remove" => "e149",
			"mk-moon-remove-2" => "e14a",
			"mk-moon-remove-3" => "e14b",
			"mk-moon-remove-4" => "e14c",
			"mk-moon-remove-5" => "e14d",
			"mk-moon-remove-6" => "e14e",
			"mk-moon-remove-7" => "e14f",
			"mk-moon-remove-8" => "e150",
			"mk-moon-briefcase" => "e151",
			"mk-moon-briefcase-2" => "e152",
			"mk-moon-briefcase-3" => "e153",
			"mk-moon-airplane" => "e154",
			"mk-moon-airplane-2" => "e155",
			"mk-moon-paper-plane" => "e156",
			"mk-moon-car" => "e157",
			"mk-moon-gas-pump" => "e158",
			"mk-moon-bus" => "e159",
			"mk-moon-truck" => "e15a",
			"mk-moon-bike" => "e15b",
			"mk-moon-road" => "e15c",
			"mk-moon-train" => "e15d",
			"mk-moon-ship" => "e15e",
			"mk-moon-boat" => "e15f",
			"mk-moon-cube" => "e160",
			"mk-moon-cube-2" => "e161",
			"mk-moon-cube-3" => "e162",
			"mk-moon-cube4" => "e163",
			"mk-moon-pyramid" => "e164",
			"mk-moon-pyramid-2" => "e165",
			"mk-moon-cylinder" => "e166",
			"mk-moon-package" => "e167",
			"mk-moon-puzzle" => "e168",
			"mk-moon-puzzle-2" => "e169",
			"mk-moon-puzzle-3" => "e16a",
			"mk-moon-puzzle-4" => "e16b",
			"mk-moon-glasses" => "e16c",
			"mk-moon-glasses-2" => "e16d",
			"mk-moon-glasses-3" => "e16e",
			"mk-moon-sun-glasses" => "e16f",
			"mk-moon-accessibility" => "e170",
			"mk-moon-accessibility-2" => "e171",
			"mk-moon-brain" => "e172",
			"mk-moon-target" => "e173",
			"mk-moon-target-2" => "e174",
			"mk-moon-target-3" => "e175",
			"mk-moon-gun" => "e176",
			"mk-moon-gun-ban" => "e177",
			"mk-moon-shield" => "e178",
			"mk-moon-shield-2" => "e179",
			"mk-moon-shield-3" => "e17a",
			"mk-moon-shield-4" => "e17b",
			"mk-moon-soccer" => "e17c",
			"mk-moon-football" => "e17d",
			"mk-moon-baseball" => "e17e",
			"mk-moon-basketball" => "e17f",
			"mk-moon-golf" => "e180",
			"mk-moon-hockey" => "e181",
			"mk-moon-racing" => "e182",
			"mk-moon-eight-ball" => "e183",
			"mk-moon-bowling-ball" => "e184",
			"mk-moon-bowling" => "e185",
			"mk-moon-bowling-2" => "e186",
			"mk-moon-lightning" => "e187",
			"mk-moon-power" => "e188",
			"mk-moon-power-2" => "e189",
			"mk-moon-switch" => "e18a",
			"mk-moon-power-cord" => "e18b",
			"mk-moon-cord" => "e18c",
			"mk-moon-socket" => "e18d",
			"mk-moon-clipboard" => "e18e",
			"mk-moon-clipboard-2" => "e18f",
			"mk-moon-signup" => "e190",
			"mk-moon-clipboard-3" => "e191",
			"mk-moon-clipboard-4" => "e192",
			"mk-moon-list" => "e193",
			"mk-moon-list-2" => "e194",
			"mk-moon-list-3" => "e195",
			"mk-moon-numbered-list" => "e196",
			"mk-moon-list-4" => "e197",
			"mk-moon-list-5" => "e198",
			"mk-moon-playlist" => "e199",
			"mk-moon-grid" => "e19a",
			"mk-moon-grid-2" => "e19b",
			"mk-moon-grid-3" => "e19c",
			"mk-moon-grid-4" => "e19d",
			"mk-moon-grid-5" => "e19e",
			"mk-moon-grid-6" => "e19f",
			"mk-moon-tree-3" => "e1a0",
			"mk-moon-tree-4" => "e1a1",
			"mk-moon-tree-5" => "e1a2",
			"mk-moon-menu" => "e1a3",
			"mk-moon-menu-2" => "e1a4",
			"mk-moon-circle-small" => "e1a5",
			"mk-moon-menu-3" => "e1a6",
			"mk-moon-menu-4" => "e1a7",
			"mk-moon-menu-5" => "e1a8",
			"mk-moon-menu-6" => "e1a9",
			"mk-moon-menu-7" => "e1aa",
			"mk-moon-menu-8" => "e1ab",
			"mk-moon-menu-9" => "e1ac",
			"mk-moon-cloud" => "e1ad",
			"mk-moon-cloud-2" => "e1ae",
			"mk-moon-cloud-3" => "e1af",
			"mk-moon-cloud-download" => "e1b0",
			"mk-moon-cloud-upload" => "e1b1",
			"mk-moon-download-2" => "e1b2",
			"mk-moon-upload-2" => "e1b3",
			"mk-moon-download-3" => "e1b4",
			"mk-moon-upload-3" => "e1b5",
			"mk-moon-download-4" => "e1b6",
			"mk-moon-upload-4" => "e1b7",
			"mk-moon-download-5" => "e1b8",
			"mk-moon-upload-5" => "e1b9",
			"mk-moon-download-6" => "e1ba",
			"mk-moon-upload-6" => "e1bb",
			"mk-moon-download-7" => "e1bc",
			"mk-moon-upload-7" => "e1bd",
			"mk-moon-globe" => "e1be",
			"mk-moon-globe-2" => "e1bf",
			"mk-moon-globe-3" => "e1c0",
			"mk-moon-earth" => "e1c1",
			"mk-moon-network" => "e1c2",
			"mk-moon-link" => "e1c3",
			"mk-moon-link-2" => "e1c4",
			"mk-moon-link-3" => "e1c5",
			"mk-moon-link2" => "e1c6",
			"mk-moon-link-4" => "e1c7",
			"mk-moon-link-5" => "e1c8",
			"mk-moon-link-6" => "e1c9",
			"mk-moon-anchor" => "e1ca",
			"mk-moon-flag" => "e1cb",
			"mk-moon-flag-2" => "e1cc",
			"mk-moon-flag-3" => "e1cd",
			"mk-moon-flag-4" => "e1ce",
			"mk-moon-flag-5" => "e1cf",
			"mk-moon-flag-6" => "e1d0",
			"mk-moon-attachment" => "e1d1",
			"mk-moon-attachment-2" => "e1d2",
			"mk-moon-eye" => "e1d3",
			"mk-moon-eye-blocked" => "e1d4",
			"mk-moon-eye-2" => "e1d5",
			"mk-moon-eye-3" => "e1d6",
			"mk-moon-eye-blocked-2" => "e1d7",
			"mk-moon-eye-4" => "e1d8",
			"mk-moon-eye-5" => "e1d9",
			"mk-moon-eye-6" => "e1da",
			"mk-moon-eye-7" => "e1db",
			"mk-moon-eye-8" => "e1dc",
			"mk-moon-bookmark" => "e1dd",
			"mk-moon-bookmark-2" => "e1de",
			"mk-moon-bookmarks" => "e1df",
			"mk-moon-bookmark-3" => "e1e0",
			"mk-moon-spotlight" => "e1e1",
			"mk-moon-starburst" => "e1e2",
			"mk-moon-snowflake" => "e1e3",
			"mk-moon-temperature" => "e1e4",
			"mk-moon-temperature-2" => "e1e5",
			"mk-moon-weather-lightning" => "e1e6",
			"mk-moon-weather-rain" => "e1e7",
			"mk-moon-weather-snow" => "e1e8",
			"mk-moon-windy" => "e1e9",
			"mk-moon-fan" => "e1ea",
			"mk-moon-umbrella" => "e1eb",
			"mk-moon-sun" => "e1ec",
			"mk-moon-sun-2" => "e1ed",
			"mk-moon-brightness-high" => "e1ee",
			"mk-moon-brightness-medium" => "e1ef",
			"mk-moon-brightness-low" => "e1f0",
			"mk-moon-brightness-contrast" => "e1f1",
			"mk-moon-contrast" => "e1f2",
			"mk-moon-moon" => "e1f3",
			"mk-moon-bed" => "e1f4",
			"mk-moon-bed-2" => "e1f5",
			"mk-moon-star" => "e1f6",
			"mk-moon-star-2" => "e1f7",
			"mk-moon-star-3" => "e1f8",
			"mk-moon-star-4" => "e1f9",
			"mk-moon-star-5" => "e1fa",
			"mk-moon-star-6" => "e1fb",
			"mk-moon-heart" => "e1fc",
			"mk-moon-heart-2" => "e1fd",
			"mk-moon-heart-3" => "e1fe",
			"mk-moon-heart-4" => "e1ff",
			"mk-moon-heart-broken" => "e200",
			"mk-moon-heart-5" => "e201",
			"mk-moon-heart-6" => "e202",
			"mk-moon-heart-broken-2" => "e203",
			"mk-moon-heart-7" => "e204",
			"mk-moon-heart-8" => "e205",
			"mk-moon-heart-broken-3" => "e206",
			"mk-moon-lips" => "e207",
			"mk-moon-lips-2" => "e208",
			"mk-moon-thumbs-up" => "e209",
			"mk-moon-thumbs-up-2" => "e20a",
			"mk-moon-thumbs-down" => "e20b",
			"mk-moon-thumbs-down-2" => "e20c",
			"mk-moon-thumbs-up-3" => "e20d",
			"mk-moon-thumbs-up-4" => "e20e",
			"mk-moon-thumbs-up-5" => "e20f",
			"mk-moon-thumbs-up-6" => "e210",
			"mk-moon-people" => "e211",
			"mk-moon-man" => "e212",
			"mk-moon-male" => "e213",
			"mk-moon-woman" => "e214",
			"mk-moon-female" => "e215",
			"mk-moon-peace" => "e216",
			"mk-moon-yin-yang" => "e217",
		);

	$icomoon2 = array(
		"mk-moon-happy" => "e218",
			"mk-moon-happy-2" => "e219",
			"mk-moon-smiley" => "e21a",
			"mk-moon-smiley-2" => "e21b",
			"mk-moon-tongue" => "e21c",
			"mk-moon-tongue-2" => "e21d",
			"mk-moon-sad" => "e21e",
			"mk-moon-sad-2" => "e21f",
			"mk-moon-wink" => "e220",
			"mk-moon-wink-2" => "e221",
			"mk-moon-grin" => "e222",
			"mk-moon-grin-2" => "e223",
			"mk-moon-cool" => "e224",
			"mk-moon-cool-2" => "e225",
			"mk-moon-angry" => "e226",
			"mk-moon-angry-2" => "e227",
			"mk-moon-evil" => "e228",
			"mk-moon-evil-2" => "e229",
			"mk-moon-shocked" => "e22a",
			"mk-moon-shocked-2" => "e22b",
			"mk-moon-confused" => "e22c",
			"mk-moon-confused-2" => "e22d",
			"mk-moon-neutral" => "e22e",
			"mk-moon-neutral-2" => "e22f",
			"mk-moon-wondering" => "e230",
			"mk-moon-wondering-2" => "e231",
			"mk-moon-cursor" => "e232",
			"mk-moon-cursor-2" => "e233",
			"mk-moon-point-up" => "e234",
			"mk-moon-point-right" => "e235",
			"mk-moon-point-down" => "e236",
			"mk-moon-point-left" => "e237",
			"mk-moon-pointer" => "e238",
			"mk-moon-hand" => "e239",
			"mk-moon-stack-empty" => "e23a",
			"mk-moon-stack-plus" => "e23b",
			"mk-moon-stack-minus" => "e23c",
			"mk-moon-stack-star" => "e23d",
			"mk-moon-stack-picture" => "e23e",
			"mk-moon-stack-down" => "e23f",
			"mk-moon-stack-up" => "e240",
			"mk-moon-stack-cancel" => "e241",
			"mk-moon-stack-checkmark" => "e242",
			"mk-moon-stack-list" => "e243",
			"mk-moon-stack-clubs" => "e244",
			"mk-moon-stack-spades" => "e245",
			"mk-moon-stack-hearts" => "e246",
			"mk-moon-stack-diamonds" => "e247",
			"mk-moon-stack-user" => "e248",
			"mk-moon-stack" => "e249",
			"mk-moon-stack-music" => "e24a",
			"mk-moon-stack-play" => "e24b",
			"mk-moon-move" => "e24c",
			"mk-moon-resize" => "e24d",
			"mk-moon-resize-2" => "e24e",
			"mk-moon-warning" => "e24f",
			"mk-moon-warning-2" => "e250",
			"mk-moon-notification" => "e251",
			"mk-moon-notification-2" => "e252",
			"mk-moon-question" => "e253",
			"mk-moon-question-2" => "e254",
			"mk-moon-question-3" => "e255",
			"mk-moon-question-4" => "e256",
			"mk-moon-question-5" => "e257",
			"mk-moon-plus-circle" => "e258",
			"mk-moon-plus-circle-2" => "e259",
			"mk-moon-minus-circle" => "e25a",
			"mk-moon-minus-circle-2" => "e25b",
			"mk-moon-info" => "e25c",
			"mk-moon-info-2" => "e25d",
			"mk-moon-blocked" => "e25e",
			"mk-moon-cancel-circle" => "e25f",
			"mk-moon-cancel-circle-2" => "e260",
			"mk-moon-checkmark-circle" => "e261",
			"mk-moon-checkmark-circle-2" => "e262",
			"mk-moon-cancel" => "e263",
			"mk-moon-spam" => "e264",
			"mk-moon-close" => "e265",
			"mk-moon-close-2" => "e266",
			"mk-moon-close-3" => "e267",
			"mk-moon-close-4" => "e268",
			"mk-moon-close-5" => "e269",
			"mk-moon-checkmark" => "e26a",
			"mk-moon-checkmark-2" => "e26b",
			"mk-moon-checkmark-3" => "e26c",
			"mk-moon-checkmark-4" => "e26d",
			"mk-moon-spell-check" => "e26e",
			"mk-moon-minus" => "e26f",
			"mk-moon-plus" => "e270",
			"mk-moon-minus-2" => "e271",
			"mk-moon-plus-2" => "e272",
			"mk-moon-enter" => "e273",
			"mk-moon-exit" => "e274",
			"mk-moon-enter-2" => "e275",
			"mk-moon-exit-2" => "e276",
			"mk-moon-enter-3" => "e277",
			"mk-moon-exit-3" => "e278",
			"mk-moon-exit-4" => "e279",
			"mk-moon-play" => "e27a",
			"mk-moon-pause" => "e27b",
			"mk-moon-stop" => "e27c",
			"mk-moon-backward" => "e27d",
			"mk-moon-forward-2" => "e27e",
			"mk-moon-play-2" => "e27f",
			"mk-moon-pause-2" => "e280",
			"mk-moon-stop-2" => "e281",
			"mk-moon-backward-2" => "e282",
			"mk-moon-forward-3" => "e283",
			"mk-moon-first" => "e284",
			"mk-moon-last" => "e285",
			"mk-moon-previous" => "e286",
			"mk-moon-next" => "e287",
			"mk-moon-eject" => "e288",
			"mk-moon-volume-high" => "e289",
			"mk-moon-volume-medium" => "e28a",
			"mk-moon-volume-low" => "e28b",
			"mk-moon-volume-mute" => "e28c",
			"mk-moon-volume-mute-2" => "e28d",
			"mk-moon-volume-increase" => "e28e",
			"mk-moon-volume-decrease" => "e28f",
			"mk-moon-volume-high-2" => "e290",
			"mk-moon-volume-medium-2" => "e291",
			"mk-moon-volume-low-2" => "e292",
			"mk-moon-volume-mute-3" => "e293",
			"mk-moon-volume-mute-4" => "e294",
			"mk-moon-volume-increase-2" => "e295",
			"mk-moon-volume-decrease-2" => "e296",
			"mk-moon-volume5" => "e297",
			"mk-moon-volume4" => "e298",
			"mk-moon-volume3" => "e299",
			"mk-moon-volume2" => "e29a",
			"mk-moon-volume1" => "e29b",
			"mk-moon-volume0" => "e29c",
			"mk-moon-volume-mute-5" => "e29d",
			"mk-moon-volume-mute-6" => "e29e",
			"mk-moon-loop" => "e29f",
			"mk-moon-loop-2" => "e2a0",
			"mk-moon-loop-3" => "e2a1",
			"mk-moon-loop-4" => "e2a2",
			"mk-moon-loop-5" => "e2a3",
			"mk-moon-shuffle" => "e2a4",
			"mk-moon-shuffle-2" => "e2a5",
			"mk-moon-wave" => "e2a6",
			"mk-moon-wave-2" => "e2a7",
			"mk-moon-arrow-first" => "e2a8",
			"mk-moon-arrow-right" => "e2a9",
			"mk-moon-arrow-up" => "e2aa",
			"mk-moon-arrow-right-2" => "e2ab",
			"mk-moon-arrow-down" => "e2ac",
			"mk-moon-arrow-left" => "e2ad",
			"mk-moon-arrow-up-2" => "e2ae",
			"mk-moon-arrow-right-3" => "e2af",
			"mk-moon-arrow-down-2" => "e2b0",
			"mk-moon-arrow-left-2" => "e2b1",
			"mk-moon-arrow-up-left" => "e2b2",
			"mk-moon-arrow-up-3" => "e2b3",
			"mk-moon-arrow-up-right" => "e2b4",
			"mk-moon-arrow-right-4" => "e2b5",
			"mk-moon-arrow-down-right" => "e2b6",
			"mk-moon-arrow-down-3" => "e2b7",
			"mk-moon-arrow-down-left" => "e2b8",
			"mk-moon-arrow-left-3" => "e2b9",
			"mk-moon-arrow-up-left-2" => "e2ba",
			"mk-moon-arrow-up-4" => "e2bb",
			"mk-moon-arrow-up-right-2" => "e2bc",
			"mk-moon-arrow-right-5" => "e2bd",
			"mk-moon-arrow-down-right-2" => "e2be",
			"mk-moon-arrow-down-4" => "e2bf",
			"mk-moon-arrow-down-left-2" => "e2c0",
			"mk-moon-arrow-left-4" => "e2c1",
			"mk-moon-arrow-up-left-3" => "e2c2",
			"mk-moon-arrow-up-5" => "e2c3",
			"mk-moon-arrow-up-right-3" => "e2c4",
			"mk-moon-arrow-right-6" => "e2c5",
			"mk-moon-arrow-down-right-3" => "e2c6",
			"mk-moon-arrow-down-5" => "e2c7",
			"mk-moon-arrow-down-left-3" => "e2c8",
			"mk-moon-arrow-left-5" => "e2c9",
			"mk-moon-arrow-up-left-4" => "e2ca",
			"mk-moon-arrow-up-6" => "e2cb",
			"mk-moon-arrow-up-right-4" => "e2cc",
			"mk-moon-arrow-right-7" => "e2cd",
			"mk-moon-arrow-down-right-4" => "e2ce",
			"mk-moon-arrow-down-6" => "e2cf",
			"mk-moon-arrow-down-left-4" => "e2d0",
			"mk-moon-arrow-left-6" => "e2d1",
			"mk-moon-arrow" => "e2d2",
			"mk-moon-arrow-2" => "e2d3",
			"mk-moon-arrow-3" => "e2d4",
			"mk-moon-arrow-4" => "e2d5",
			"mk-moon-arrow-5" => "e2d6",
			"mk-moon-arrow-6" => "e2d7",
			"mk-moon-arrow-7" => "e2d8",
			"mk-moon-arrow-8" => "e2d9",
			"mk-moon-arrow-up-left-5" => "e2da",
			"mk-moon-arrow-square" => "e2db",
			"mk-moon-arrow-up-right-5" => "e2dc",
			"mk-moon-arrow-right-8" => "e2dd",
			"mk-moon-arrow-down-right-5" => "e2de",
			"mk-moon-arrow-down-7" => "e2df",
			"mk-moon-arrow-down-left-5" => "e2e0",
			"mk-moon-arrow-left-7" => "e2e1",
			"mk-moon-arrow-up-7" => "e2e2",
			"mk-moon-arrow-right-9" => "e2e3",
			"mk-moon-arrow-down-8" => "e2e4",
			"mk-moon-arrow-left-8" => "e2e5",
			"mk-moon-arrow-up-8" => "e2e6",
			"mk-moon-arrow-right-10" => "e2e7",
			"mk-moon-arrow-bottom" => "e2e8",
			"mk-moon-arrow-left-9" => "e2e9",
			"mk-moon-arrow-up-left-6" => "e2ea",
			"mk-moon-arrow-up-9" => "e2eb",
			"mk-moon-arrow-up-right-6" => "e2ec",
			"mk-moon-arrow-right-11" => "e2ed",
			"mk-moon-arrow-down-right-6" => "e2ee",
			"mk-moon-arrow-down-9" => "e2ef",
			"mk-moon-arrow-down-left-6" => "e2f0",
			"mk-moon-arrow-left-10" => "e2f1",
			"mk-moon-arrow-up-left-7" => "e2f2",
			"mk-moon-arrow-up-10" => "e2f3",
			"mk-moon-arrow-up-right-7" => "e2f4",
			"mk-moon-arrow-right-12" => "e2f5",
			"mk-moon-arrow-down-right-7" => "e2f6",
			"mk-moon-arrow-down-10" => "e2f7",
			"mk-moon-arrow-down-left-7" => "e2f8",
			"mk-moon-arrow-left-11" => "e2f9",
			"mk-moon-arrow-up-11" => "e2fa",
			"mk-moon-arrow-right-13" => "e2fb",
			"mk-moon-arrow-down-11" => "e2fc",
			"mk-moon-arrow-left-12" => "e2fd",
			"mk-moon-arrow-up-12" => "e2fe",
			"mk-moon-arrow-right-14" => "e2ff",
			"mk-moon-arrow-down-12" => "e300",
			"mk-moon-arrow-left-13" => "e301",
			"mk-moon-arrow-up-13" => "e302",
			"mk-moon-arrow-right-15" => "e303",
			"mk-moon-arrow-down-13" => "e304",
			"mk-moon-arrow-left-14" => "e305",
			"mk-moon-arrow-up-14" => "e306",
			"mk-moon-arrow-right-16" => "e307",
			"mk-moon-arrow-down-14" => "e308",
			"mk-moon-arrow-left-15" => "e309",
			"mk-moon-arrow-up-15" => "e30a",
			"mk-moon-arrow-right-17" => "e30b",
			"mk-moon-arrow-down-15" => "e30c",
			"mk-moon-arrow-left-16" => "e30d",
			"mk-moon-arrow-up-16" => "e30e",
			"mk-moon-arrow-right-18" => "e30f",
			"mk-moon-arrow-down-16" => "e310",
			"mk-moon-arrow-left-17" => "e311",
			"mk-moon-menu-10" => "e312",
			"mk-moon-menu-11" => "e313",
			"mk-moon-menu-close" => "e314",
			"mk-moon-menu-close-2" => "e315",
			"mk-moon-enter-4" => "e316",
			"mk-moon-enter-5" => "e317",
			"mk-moon-esc" => "e318",
			"mk-moon-backspace" => "e319",
			"mk-moon-backspace-2" => "e31a",
			"mk-moon-backspace-3" => "e31b",
			"mk-moon-tab" => "e31c",
			"mk-moon-transmission" => "e31d",
			"mk-moon-transmission-2" => "e31e",
			"mk-moon-sort" => "e31f",
			"mk-moon-sort-2" => "e320",
			"mk-moon-key-keyboard" => "e321",
			"mk-moon-key-A" => "e322",
			"mk-moon-key-up" => "e323",
			"mk-moon-key-right" => "e324",
			"mk-moon-key-down" => "e325",
			"mk-moon-key-left" => "e326",
			"mk-moon-command" => "e327",
			"mk-moon-checkbox-checked" => "e328",
			"mk-moon-checkbox-unchecked" => "e329",
			"mk-moon-square" => "e32a",
			"mk-moon-checkbox-partial" => "e32b",
			"mk-moon-checkbox" => "e32c",
			"mk-moon-checkbox-unchecked-2" => "e32d",
			"mk-moon-checkbox-partial-2" => "e32e",
			"mk-moon-checkbox-checked-2" => "e32f",
			"mk-moon-checkbox-unchecked-3" => "e330",
			"mk-moon-checkbox-partial-3" => "e331",
			"mk-moon-radio-checked" => "e332",
			"mk-moon-radio-unchecked" => "e333",
			"mk-moon-circle" => "e334",
			"mk-moon-circle-2" => "e335",
			"mk-moon-crop" => "e336",
			"mk-moon-crop-2" => "e337",
			"mk-moon-vector" => "e338",
			"mk-moon-rulers" => "e339",
			"mk-moon-scissors" => "e33a",
			"mk-moon-scissors-2" => "e33b",
			"mk-moon-scissors-3" => "e33c",
			"mk-moon-filter" => "e33d",
			"mk-moon-filter-2" => "e33e",
			"mk-moon-filter-3" => "e33f",
			"mk-moon-filter-4" => "e340",
			"mk-moon-font" => "e341",
			"mk-moon-font-size" => "e342",
			"mk-moon-type" => "e343",
			"mk-moon-text-height" => "e344",
			"mk-moon-text-width" => "e345",
			"mk-moon-height" => "e346",
			"mk-moon-width" => "e347",
			"mk-moon-bold" => "e348",
			"mk-moon-underline" => "e349",
			"mk-moon-italic" => "e34a",
			"mk-moon-strikethrough" => "e34b",
			"mk-moon-strikethrough-2" => "e34c",
			"mk-moon-font-size-2" => "e34d",
			"mk-moon-bold-2" => "e34e",
			"mk-moon-underline-2" => "e34f",
			"mk-moon-italic-2" => "e350",
			"mk-moon-strikethrough-3" => "e351",
			"mk-moon-omega" => "e352",
			"mk-moon-sigma" => "e353",
			"mk-moon-nbsp" => "e354",
			"mk-moon-page-break" => "e355",
			"mk-moon-page-break-2" => "e356",
			"mk-moon-superscript" => "e357",
			"mk-moon-subscript" => "e358",
			"mk-moon-superscript-2" => "e359",
			"mk-moon-subscript-2" => "e35a",
			"mk-moon-text-color" => "e35b",
			"mk-moon-highlight" => "e35c",
			"mk-moon-pagebreak" => "e35d",
			"mk-moon-clear-formatting" => "e35e",
			"mk-moon-table" => "e35f",
			"mk-moon-table-2" => "e360",
			"mk-moon-insert-template" => "e361",
			"mk-moon-pilcrow" => "e362",
			"mk-moon-left-to-right" => "e363",
			"mk-moon-right-to-left" => "e364",
			"mk-moon-paragraph-left" => "e365",
			"mk-moon-paragraph-center" => "e366",
			"mk-moon-paragraph-right" => "e367",
			"mk-moon-paragraph-justify" => "e368",
			"mk-moon-paragraph-left-2" => "e369",
			"mk-moon-paragraph-center-2" => "e36a",
			"mk-moon-paragraph-right-2" => "e36b",
			"mk-moon-paragraph-justify-2" => "e36c",
			"mk-moon-indent-increase" => "e36d",
			"mk-moon-indent-decrease" => "e36e",
			"mk-moon-paragraph-left-3" => "e36f",
			"mk-moon-paragraph-center-3" => "e370",
			"mk-moon-paragraph-right-3" => "e371",
			"mk-moon-paragraph-justify-3" => "e372",
			"mk-moon-indent-increase-2" => "e373",
			"mk-moon-indent-decrease-2" => "e374",
			"mk-moon-share" => "e375",
			"mk-moon-new-tab" => "e376",
			"mk-moon-new-tab-2" => "e377",
			"mk-moon-popout" => "e378",
			"mk-moon-embed" => "e379",
			"mk-moon-code" => "e37a",
			"mk-moon-console" => "e37b",
			"mk-moon-seven-segment-0" => "e37c",
			"mk-moon-seven-segment-1" => "e37d",
			"mk-moon-seven-segment-2" => "e37e",
			"mk-moon-seven-segment-3" => "e37f",
			"mk-moon-seven-segment-4" => "e380",
			"mk-moon-seven-segment-5" => "e381",
			"mk-moon-seven-segment-6" => "e382",
			"mk-moon-seven-segment-7" => "e383",
			"mk-moon-seven-segment-8" => "e384",
			"mk-moon-seven-segment-9" => "e385",
			"mk-moon-share-2" => "e386",
			"mk-moon-share-3" => "e387",
			"mk-moon-mail" => "e388",
			"mk-moon-mail-2" => "e389",
			"mk-moon-mail-3" => "e38a",
			"mk-moon-mail-4" => "e38b",
			"mk-moon-google" => "e38c",
			"mk-moon-google-plus" => "e38d",
			"mk-moon-google-plus-2" => "e38e",
			"mk-moon-google-plus-3" => "e38f",
			"mk-moon-google-plus-4" => "e390",
			"mk-moon-google-drive" => "e391",
			"mk-moon-facebook" => "e392",
			"mk-moon-facebook-2" => "e393",
			"mk-moon-facebook-3" => "e394",
			"mk-moon-facebook-4" => "e395",
			"mk-moon-instagram" => "e396",
			"mk-moon-twitter" => "e397",
			"mk-moon-twitter-2" => "e398",
			"mk-moon-twitter-3" => "e399",
			"mk-moon-feed-2" => "e39a",
			"mk-moon-feed-3" => "e39b",
			"mk-moon-feed-4" => "e39c",
			"mk-moon-youtube" => "e39d",
			"mk-moon-youtube-2" => "e39e",
			"mk-moon-vimeo" => "e39f",
			"mk-moon-vimeo2" => "e3a0",
			"mk-moon-vimeo-2" => "e3a1",
			"mk-moon-lanyrd" => "e3a2",
			"mk-moon-flickr" => "e3a3",
			"mk-moon-flickr-2" => "e3a4",
			"mk-moon-flickr-3" => "e3a5",
			"mk-moon-flickr-4" => "e3a6",
			"mk-moon-picassa" => "e3a7",
			"mk-moon-picassa-2" => "e3a8",
			"mk-moon-dribbble" => "e3a9",
			"mk-moon-dribbble-2" => "e3aa",
			"mk-moon-dribbble-3" => "e3ab",
			"mk-moon-forrst" => "e3ac",
			"mk-moon-forrst-2" => "e3ad",
			"mk-moon-deviantart" => "e3ae",
			"mk-moon-deviantart-2" => "e3af",
			"mk-moon-steam" => "e3b0",
			"mk-moon-steam-2" => "e3b1",
			"mk-moon-github" => "e3b2",
			"mk-moon-github-2" => "e3b3",
			"mk-moon-github-3" => "e3b4",
			"mk-moon-github-4" => "e3b5",
			"mk-moon-github-5" => "e3b6",
			"mk-moon-wordpress" => "e3b7",
			"mk-moon-wordpress-2" => "e3b8",
			"mk-moon-joomla" => "e3b9",
			"mk-moon-blogger" => "e3ba",
			"mk-moon-blogger-2" => "e3bb",
			"mk-moon-tumblr" => "e3bc",
			"mk-moon-tumblr-2" => "e3bd",
			"mk-moon-yahoo" => "e3be",
			"mk-moon-tux" => "e3bf",
			"mk-moon-apple" => "e3c0",
			"mk-moon-finder" => "e3c1",
			"mk-moon-android" => "e3c2",
			"mk-moon-windows" => "e3c3",
			"mk-moon-windows8" => "e3c4",
			"mk-moon-soundcloud" => "e3c5",
			"mk-moon-soundcloud-2" => "e3c6",
			"mk-moon-skype" => "e3c7",
			"mk-moon-reddit" => "e3c8",
			"mk-moon-linkedin" => "e3c9",
			"mk-moon-lastfm" => "e3ca",
			"mk-moon-lastfm-2" => "e3cb",
			"mk-moon-delicious" => "e3cc",
			"mk-moon-stumbleupon" => "e3cd",
			"mk-moon-stumbleupon-2" => "e3ce",
			"mk-moon-stackoverflow" => "e3cf",
			"mk-moon-pinterest" => "e3d0",
			"mk-moon-pinterest-2" => "e3d1",
			"mk-moon-xing" => "e3d2",
			"mk-moon-xing-2" => "e3d3",
			"mk-moon-flattr" => "e3d4",
			"mk-moon-foursquare" => "e3d5",
			"mk-moon-foursquare-2" => "e3d6",
			"mk-moon-paypal" => "e3d7",
			"mk-moon-paypal-2" => "e3d8",
			"mk-moon-paypal-3" => "e3d9",
			"mk-moon-yelp" => "e3da",
			"mk-moon-libreoffice" => "e3db",
			"mk-moon-file-pdf" => "e3dc",
			"mk-moon-file-openoffice" => "e3dd",
			"mk-moon-file-word" => "e3de",
			"mk-moon-file-excel" => "e3df",
			"mk-moon-file-zip" => "e3e0",
			"mk-moon-file-powerpoint" => "e3e1",
			"mk-moon-file-xml" => "e3e2",
			"mk-moon-file-css" => "e3e3",
			"mk-moon-html5" => "e3e4",
			"mk-moon-html5-2" => "e3e5",
			"mk-moon-home-7" => "e3e6",
			"mk-moon-home-8" => "e3e7",
			"mk-moon-home-9" => "e3e8",
			"mk-moon-home-10" => "e3e9",
			"mk-moon-home-11" => "e3ea",
			"mk-moon-office" => "e3eb",
			"mk-moon-newspaper" => "e3ec",
			"mk-moon-pencil" => "e3ed",
			"mk-moon-pencil-2" => "e3ee",
			"mk-moon-pencil-3" => "e3ef",
			"mk-moon-pencil-4" => "e3f0",
			"mk-moon-pencil-5" => "e3f1",
			"mk-moon-pencil-6" => "e3f2",
			"mk-moon-quill-3" => "e3f3",
			"mk-moon-pen-5" => "e3f4",
			"mk-moon-marker" => "e3f5",
			"mk-moon-home-12" => "e3f6",
			"mk-moon-marker-2" => "e3f7",
			"mk-moon-blog" => "e3f8",
			"mk-moon-blog-2" => "e3f9",
			"mk-moon-brush" => "e3fa",
			"mk-moon-palette" => "e3fb",
			"mk-moon-palette-2" => "e3fc",
			"mk-moon-eyedropper" => "e3fd",
			"mk-moon-eyedropper-2" => "e3fe",
			"mk-moon-droplet-2" => "e3ff",
			"mk-moon-droplet-3" => "e400",
			"mk-moon-droplet-4" => "e401",
			"mk-moon-images" => "e402",
			"mk-moon-image-4" => "e403",
			"mk-moon-image-5" => "e404",
			"mk-moon-image-6" => "e405",
			"mk-moon-images-2" => "e406",
			"mk-moon-image-7" => "e407",
			"mk-moon-camera" => "e408",
			"mk-moon-camera-2" => "e409",
			"mk-moon-camera-3" => "e40a",
			"mk-moon-camera-4" => "e40b",
			"mk-moon-music-3" => "e40c",
			"mk-moon-music-4" => "e40d",
			"mk-moon-music-5" => "e40e",
			"mk-moon-music-6" => "e40f",
			"mk-moon-play-3" => "e410",
			"mk-moon-play-4" => "e411",
			"mk-moon-movie" => "e412",
			"mk-moon-movie-2" => "e413",
			"mk-moon-movie-3" => "e414",
			"mk-moon-film" => "e415",
			"mk-moon-film-2" => "e416",
			"mk-moon-film-3" => "e417",
			"mk-moon-film-4" => "e418",
			"mk-moon-camera-5" => "e419",
			"mk-moon-camera-6" => "e41a",
			"mk-moon-camera-7" => "e41b",
			"mk-moon-camera-8" => "e41c",
			"mk-moon-camera-9" => "e41d",
			"mk-moon-clubs" => "e41e",
			"mk-moon-diamonds" => "e41f",
			"mk-moon-king" => "e420",
			"mk-moon-queen" => "e421",
			"mk-moon-rock" => "e422",
			"mk-moon-bishop" => "e423",
			"mk-moon-knight" => "e424",
			"mk-moon-pawn" => "e425",
			"mk-moon-chess" => "e426",
			"mk-moon-bullhorn" => "e427",
			"mk-moon-megaphone" => "e428",
			"mk-moon-new" => "e429",
			"mk-moon-connection-2" => "e42a",
			"mk-moon-connection-3" => "e42b",
			"mk-moon-podcast-3" => "e42c",
			"mk-moon-mic" => "e42d",
			"mk-moon-mic-2" => "e42e",
			"mk-moon-mic-3" => "e42f",
			"mk-moon-mic-4" => "e430",
			"mk-moon-mic-5" => "e431",
			"mk-moon-book" => "e432",
			"mk-moon-book-2" => "e433",
			"mk-moon-books" => "e434",
			"mk-moon-reading" => "e435",
			"mk-moon-library" => "e436",
			"mk-moon-library-2" => "e437",
			"mk-moon-graduation" => "e438",
			"mk-moon-file-7" => "e439",
			"mk-moon-files" => "e43a",
			"mk-moon-file-plus" => "e43b",
			"mk-moon-file-minus" => "e43c",
			"mk-moon-file-download" => "e43d",
			"mk-moon-file-upload" => "e43e",
			"mk-moon-file-check" => "e43f",
			"mk-moon-file-remove-2" => "e440",
			"mk-moon-file-8" => "e441",
			"mk-moon-file-9" => "e442",
			"mk-moon-file-plus-2" => "e443",
			"mk-moon-file-minus-2" => "e444",
			"mk-moon-file-download-2" => "e445",
			"mk-moon-file-upload-2" => "e446",
			"mk-moon-file-check-2" => "e447",
			"mk-moon-paste" => "e448",
			"mk-moon-paste-2" => "e449",
			"mk-moon-paste-3" => "e44a",
			"mk-moon-stack-2" => "e44b",
			"mk-moon-stack-3" => "e44c",
			"mk-moon-stack-4" => "e44d",
			"mk-moon-folder-4" => "e44e",
			"mk-moon-folder-download" => "e44f",
			"mk-moon-folder-upload" => "e450",
			"mk-moon-folder-plus-2" => "e451",
			"mk-moon-folder-plus-3" => "e452",
			"mk-moon-folder-minus" => "e453",
			"mk-moon-folder-minus-2" => "e454",
			"mk-moon-folder8" => "e455",
			"mk-moon-folder-minus-3" => "e456",
			"mk-moon-folder-plus-4" => "e457",
			"mk-moon-folder-remove-2" => "e458",
			"mk-moon-folder-download-2" => "e459",
			"mk-moon-folder-upload-2" => "e45a",
			"mk-moon-folder-download-3" => "e45b",
			"mk-moon-folder-upload-3" => "e45c",
			"mk-moon-folder-5" => "e45d",
			"mk-moon-folder-open-2" => "e45e",
			"mk-moon-folder-6" => "e45f",
			"mk-moon-folder-open-3" => "e460",
			"mk-moon-certificate" => "e461",
			"mk-moon-cc" => "e462",
			"mk-moon-tag-7" => "e463",
			"mk-moon-tags" => "e464",
			"mk-moon-tags-2" => "e465",
			"mk-moon-tag-8" => "e466",
			"mk-moon-barcode" => "e467",
			"mk-moon-barcode-2" => "e468",
			"mk-moon-qrcode" => "e469",
			"mk-moon-ticket" => "e46a",
			"mk-moon-cart" => "e46b",
			"mk-moon-cart-2" => "e46c",
			"mk-moon-cart-3" => "e46d",
			"mk-moon-cart-4" => "e46e",
			"mk-moon-cart-5" => "e46f",
			"mk-moon-cart-6" => "e470",
			"mk-moon-cart-7" => "e471",
			"mk-moon-basket" => "e472",
			"mk-moon-basket-2" => "e473",
			"mk-moon-bag" => "e474",
			"mk-moon-bag-2" => "e475",
			"mk-moon-bag-3" => "e476",
			"mk-moon-coin" => "e477",
			"mk-moon-coins" => "e478",
			"mk-moon-credit" => "e479",
			"mk-moon-credit-2" => "e47a",
			"mk-moon-calculate" => "e47b",
			"mk-moon-calculate-2" => "e47c",
			"mk-moon-support" => "e47d",
			"mk-moon-phone-3" => "e47e",
			"mk-moon-phone-4" => "e47f",
			"mk-moon-call-incoming" => "e480",
			"mk-moon-call-outgoing" => "e481",
			"mk-moon-phone-5" => "e482",
			"mk-moon-phone-6" => "e483",
			"mk-moon-phone-hang-up" => "e484",
			"mk-moon-phone-hang-up-2" => "e485",
			"mk-moon-address-book" => "e486",
			"mk-moon-address-book-2" => "e487",
			"mk-moon-notebook" => "e488",
			"mk-moon-envelop" => "e489",
			"mk-moon-envelop-2" => "e48a",
			"mk-moon-mail-send" => "e48b",
			"mk-moon-envelop-opened" => "e48c",
			"mk-moon-envelop-3" => "e48d",
	);


		switch ($family) {
			case 'icomoon1':
				return $icomoon1;
				break;
			case 'icomoon2':
				return $icomoon2;
				break;	
			case 'line':
				return $line;
				break;
			case 'fontawesome':
				return $fontawesome;
				break;
			case 'all':
			return $line + $icomoon1 + $icomoon2 + $fontawesome;
				break;
			default:
				return $line;
				break;
		}

	}

}


new Mk_Icon_Library();
	 
