<?php
/**
 * This file represents an example of the code that themes would use to register
 * the required plugins.
 *
 * It is expected that theme authors would copy and paste this code into their
 * functions.php file, and amend to suit.
 *
 * @see http://tgmpluginactivation.com/configuration/ for detailed documentation.
 *
 * @package    TGM-Plugin-Activation
 * @subpackage Example
 * @version    2.6.1
 * @author     Thomas Griffin, Gary Jones, Juliette Reinders Folmer
 * @copyright  Copyright (c) 2011, Thomas Griffin
 * @license    http://opensource.org/licenses/gpl-2.0.php GPL v2 or later
 * @link       https://github.com/TGMPA/TGM-Plugin-Activation
 */


/**
 * Include the TGM_Plugin_Activation class.
 */
require_once dirname( __FILE__ ) . '/class-tgm-plugin-activation.php';

add_action( 'tgmpa_register', 'mk_jupiter_register_required_plugins' );


function mk_jupiter_register_required_plugins() {

    $plugins = array(
        
        array(
            'name' => __( 'Visual Composer', 'mk_framework' ),
            'slug' => 'js_composer_theme',
            'source' => 'http://static-cdn.artbees.net/plugins/js_composer_theme.zip',
            'required' => true,
            'version' => '5.0.2',
            'force_activation' => false,
            'force_deactivation' => false
        ),

        array(
            'name' => __( 'Artbees Themes Captcha', 'mk_framework' ),
            'slug' => 'artbees-captcha',
            'source' => 'http://static-cdn.artbees.net/plugins/artbees-captcha.zip',
            'required' => true,
            'version' => '1.0',
            'force_activation' => false,
            'force_deactivation' => false
        ),

        array(
            'name' => __( 'Layer Slider', 'mk_framework' ),
            'slug' => 'LayerSlider',
            'source' => 'http://static-cdn.artbees.net/plugins/LayerSlider.zip',
            'required' => false,
            'version' => '6.1.6',
            'force_activation' => false,
            'force_deactivation' => false
        ),

        array(
            'name' => __( 'Slider Revolution', 'mk_framework' ),
            'slug' => 'revslider',
            'source' => 'http://static-cdn.artbees.net/plugins/revslider.zip',
            'required' => false,
            'version' => '5.3.1.5',
            'force_activation' => false,
            'force_deactivation' => false
        ),

        array(
            'name' => __( 'Master Slider', 'mk_framework' ),
            'slug' => 'masterslider',
            'source' => 'http://static-cdn.artbees.net/plugins/masterslider.zip',
            'required' => false,
            'version' => '3.1.1',
            'force_activation' => false,
            'force_deactivation' => false
        ),
    );

    /*
     * Array of configuration settings. Amend each line as needed.
     *
     * TGMPA will start providing localized text strings soon. If you already have translations of our standard
     * strings available, please help us make TGMPA even better by giving us access to these translations or by
     * sending in a pull-request with .po file(s) with the translations.
     *
     * Only uncomment the strings in the config array if you want to customize the strings.
     *
     * Some of the strings are wrapped in a sprintf(), so see the comments at the
     * end of each line for what each argument will be.
     */
    $config = array(
        'id'           => 'tgmpa',                 // Unique ID for hashing notices for multiple instances of TGMPA.
        'default_path' => '',                      // Default absolute path to pre-packaged plugins.
        'menu'         => 'tgmpa-install-plugins', // Menu slug.
        'parent_slug'  => 'themes.php',            // Parent menu slug.
        'capability'   => 'edit_theme_options',    // Capability needed to view plugin install page, should be a capability associated with the parent menu used.
        'has_notices'  => true,                    // Show admin notices or not.
        'dismissable'  => true,                    // If false, a user cannot dismiss the nag message.
        'dismiss_msg'  => '',                      // If 'dismissable' is false, this message will be output at top of nag.
        'is_automatic' => false,                   // Automatically activate plugins after installation or not.
        'message'      => '',                      // Message to output right before the plugins table.
        'strings'      => array(
            'page_title'                      => __( 'Install Required Plugins', 'mk_framework' ),
            'menu_title'                      => __( 'Install Plugins', 'mk_framework' ),
            'installing'                      => __( 'Installing Plugin: %s', 'mk_framework' ), // %s = plugin name.
            'oops'                            => __( 'Something went wrong with the plugin API.', 'mk_framework' ),
            'notice_can_install_required'     => _n_noop(
                'This theme requires the following plugin: %1$s.',
                'This theme requires the following plugins: %1$s.',
                'mk_framework'
            ), // %1$s = plugin name(s).
            'notice_can_install_recommended'  => _n_noop(
                'This theme recommends the following plugin: %1$s.',
                'This theme recommends the following plugins: %1$s.',
                'mk_framework'
            ), // %1$s = plugin name(s).
            'notice_cannot_install'           => _n_noop(
                'Sorry, but you do not have the correct permissions to install the %1$s plugin.',
                'Sorry, but you do not have the correct permissions to install the %1$s plugins.',
                'mk_framework'
            ), // %1$s = plugin name(s).
            'notice_ask_to_update'            => _n_noop(
                'The following plugin needs to be updated to its latest version to ensure maximum compatibility with this theme: %1$s.',
                'The following plugins need to be updated to their latest version to ensure maximum compatibility with this theme: %1$s.',
                'mk_framework'
            ), // %1$s = plugin name(s).
            'notice_ask_to_update_maybe'      => _n_noop(
                'There is an update available for: %1$s.',
                'There are updates available for the following plugins: %1$s.',
                'mk_framework'
            ), // %1$s = plugin name(s).
            'notice_cannot_update'            => _n_noop(
                'Sorry, but you do not have the correct permissions to update the %1$s plugin.',
                'Sorry, but you do not have the correct permissions to update the %1$s plugins.',
                'mk_framework'
            ), // %1$s = plugin name(s).
            'notice_can_activate_required'    => _n_noop(
                'The following required plugin is currently inactive: %1$s.',
                'The following required plugins are currently inactive: %1$s.',
                'mk_framework'
            ), // %1$s = plugin name(s).
            'notice_can_activate_recommended' => _n_noop(
                'The following recommended plugin is currently inactive: %1$s.',
                'The following recommended plugins are currently inactive: %1$s.',
                'mk_framework'
            ), // %1$s = plugin name(s).
            'notice_cannot_activate'          => _n_noop(
                'Sorry, but you do not have the correct permissions to activate the %1$s plugin.',
                'Sorry, but you do not have the correct permissions to activate the %1$s plugins.',
                'mk_framework'
            ), // %1$s = plugin name(s).
            'install_link'                    => _n_noop(
                'Begin installing plugin',
                'Begin installing plugins',
                'mk_framework'
            ),
            'update_link'                     => _n_noop(
                'Begin updating plugin',
                'Begin updating plugins',
                'mk_framework'
            ),
            'activate_link'                   => _n_noop(
                'Begin activating plugin',
                'Begin activating plugins',
                'mk_framework'
            ),
            'return'                          => __( 'Return to Required Plugins Installer', 'mk_framework' ),
            'plugin_activated'                => __( 'Plugin activated successfully.', 'mk_framework' ),
            'activated_successfully'          => __( 'The following plugin was activated successfully:', 'mk_framework' ),
            'plugin_already_active'           => __( 'No action taken. Plugin %1$s was already active.', 'mk_framework' ),  // %1$s = plugin name(s).
            'plugin_needs_higher_version'     => __( 'Plugin not activated. A higher version of %s is needed for this theme. Please update the plugin.', 'mk_framework' ),  // %1$s = plugin name(s).
            'complete'                        => __( 'All plugins installed and activated successfully. %1$s', 'mk_framework' ), // %s = dashboard link.
            'contact_admin'                   => __( 'Please contact the administrator of this site for help.', 'mk_framework' ),

            'nag_type'                        => 'updated', // Determines admin notice type - can only be 'updated', 'update-nag' or 'error'.
        )
    );

    tgmpa( $plugins, $config );

}